#ifndef __BLE_HUMIDITY_MEASURE_SERVICE_H__
#define __BLE_HUMIDITY_MEASURE_SERVICE_H__

class HumidityMeasureService {
public:
    const static uint16_t HUMIDITY_MEASURE_SERVICE_UUID = 0xA004;
    const static uint16_t HUMIDITY_CHARACTERISTIC_UUID = 0xA005;

    HumidityMeasureService(BLEDevice &_ble, float humidity) :
        ble(_ble), 
        humidityValue(HUMIDITY_CHARACTERISTIC_UUID, &humidity, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ)
    {
        GattCharacteristic *charTable[] = {&humidityValue};
        GattService         getHumidityService(HUMIDITY_MEASURE_SERVICE_UUID, charTable, sizeof(charTable) / sizeof(GattCharacteristic *));
        ble.addService(getHumidityService);
    }

    GattAttribute::Handle_t getValueHandle() const {
        return humidityValue.getValueHandle();
    }
    
    void updateHumidity(uint8_t newHum) {
        ble.gattServer().write(humidityValue.getValueHandle(), &newHum, 1);
    }

public:
    BLEDevice                         &ble;
    ReadWriteGattCharacteristic<float>  humidityValue;
};

#endif /* #ifndef __BLE_HUMIDITY_MEASURE_SERVICE_H__ */