#include "mbed.h"
//#include "main.h"
#include "DataGlove.h"
#include "Glove.h"
#include "Correction.h"
#include "GestureRecognition.h"
#include "CubeUpdateParameters.h"
#include "LedCube.h" 

#pragma once

DataGlove MasterGlove;
Correction Correct;
GestureRecognition gestureSet; 
LedCube cube; 



int main() 
{
    long Counter = 0;
    DigitalOut StatusLED(LED2);
    StatusLED = 0;
    Glove unfiltered;
    Glove filtered;
    CubeUpdateParameters params; 
    Serial pc(USBTX, USBRX);
    pc.baud(115200);
    pc.printf("Connected to PC \r\n");
    MasterGlove.Init();
    cube.Init(0,0,0);
    pc.printf("DataGlove Cube Client\r\n");
    
    //cube.cubeUpdate();
    while(true) 
    {
        unfiltered = MasterGlove.ReceiveBlocking();
        filtered = Correct.Correct(unfiltered);
        params = gestureSet.sensorToGesture(filtered);
        /*params.size = 2;
        params.deltaX = 0;
        params.deltaY = 0;
        params.deltaZ = 0;
        params.hue = 0.5; */
        cube.UpdateCube2(params); 
        //pc.printf("Looping \r\n");
        //wait(0.1);
        if(Counter++%25 == 0)
        {
            StatusLED = !StatusLED;
        }
     }
}
