#include "GloveWifi.h"
#include "Glove.h"

#pragma once

class DataGlove
{
    public:
        DataGlove();
        ~DataGlove();
        void Init();
        bool Receive();
        Glove ReceiveBlocking();
        
        //Returns the latest glove values in a structure.
        Glove GetCurrentValues();
        //Returns true if new data since last function call, false otherwise. 
        bool CheckForNewValues();
        
        int16_t finger1, finger2, finger3, finger4, finger5;
        int16_t accelx, accely, accelz;
        int16_t gyrox, gyroy, gyroz;
        
    private:
        uint8_t SendBuf[20];
        int16_t notConnectedCount;
        long numReceived;
        char Buf[256];//, buffer[256];
        //bool raw;
        unsigned char bcc;
        int pkglen, u;
        int timeOfArrival, id, pkgtype;
        int j, k, y;
        float roll, yaw, pitch;
        float norm, test;
        int q0, q1, q2, q3;
        float q00, q11, q22, q33;
        long ReceiveCount;
        bool NewData;
        // Stores glove data
        Glove gl;
        GloveWifi GloveSocket;
        
    private:
        void Parse();
        void StreamData(uint8_t DataType);
        void StopSampling();
        void ExtractFingersQuat();
        void ExtractQuat();
        void ExtractFingersRaw();
        void ExtractRaw();
        void ExtractFingers();
};