#include "GloveWifi.h"
#include "mbed.h"
#include "cc3000.h"
#include "TCPSocketConnection.h"
#include "TCPSocketServer.h"
#include "NVIC_set_all_priorities.h"

#define SSID "CubeNet"
#define PASSWORD "modelbased"

#define ECHO_SERVER_ADDRESS     "192.168.1.33"
#define ECHO_SERVER_PORT        2000
#define MMA8451_I2C_ADDRESS     (0x1d<<1)

GloveWifi::GloveWifi():
DropCount(0)
{
}

GloveWifi::~GloveWifi()
{
    delete socket;
    delete wifi;
}

void GloveWifi::Init()
{

    //Init from the cc3000 example
    DigitalOut PWR_EN1(PTB2);
    DigitalOut PWR_EN2(PTB3);

    // Wi-Go set current to 500mA since we're turning on the Wi-Fi
    PWR_EN1 = 0;
    PWR_EN2 = 1;

    NVIC_set_all_irq_priorities(0x3);
    NVIC_SetPriority(SPI0_IRQn, 0x0);     // Wi-Fi SPI interrupt must be higher priority than SysTick
    NVIC_SetPriority(PORTA_IRQn, 0x1);
    NVIC_SetPriority(SysTick_IRQn, 0x2);  // SysTick set to lower priority than Wi-Fi SPI bus interrupt
    PORTA->PCR[16] |= PORT_PCR_ISF_MASK;
    PORTA->ISFR |= (1 << 16);
}

void GloveWifi::Connect()
{
    
    //wifi = new cc3000(PTD4, PTC9, PTD0, SPI(PTD2, PTD3, PTD1), SSID, PASSWORD, WPA2, false); 
    wifi = new cc3000(PTD4, PTC9, PTC4, SPI(PTC6, PTC7, PTC5), SSID, PASSWORD, WPA2, false);
    wifi->init();
    if (wifi->connect() == -1) 
    {
        printf("Failed to connect. Please verify connection details and try again. \r\n");
    } else 
    {
        printf("IP address: %s \r\n", wifi->getIPAddress());
    }
    socket = new TCPSocketConnection;
    while (socket->connect(ECHO_SERVER_ADDRESS, ECHO_SERVER_PORT) < 0) 
    {
        printf("Unable to connect to (%s) on port (%d) \r\n", ECHO_SERVER_ADDRESS, ECHO_SERVER_PORT);
        wait(1);
    }
    printf("Connected!\r\n");
    socket->set_blocking(false, 10);
    
}

void GloveWifi::Disconnect()
{
    socket->close();
    wifi->disconnect();
    delete socket;
    delete wifi;
}

void GloveWifi::Reconnect()
{
    socket->close();
    delete socket;
    socket = new TCPSocketConnection;
    while (socket->connect(ECHO_SERVER_ADDRESS, ECHO_SERVER_PORT) < 0) 
    {
        printf("Unable to connect to (%s) on port (%d) \r\n", ECHO_SERVER_ADDRESS, ECHO_SERVER_PORT);
        wait(1);
    }
    socket->set_blocking(false, 10);
    //printf("Reconnected!\r\n");
}

int GloveWifi::GetDataFromBuffer(char * buf, int size)
{
    //printf("Buffer Size: %d\r\n", wifi->_simple_link.get_transmit_error());
    int numR = 0;
    numR = socket->receive((char *)buf, size);
    if(numR == -1)
    {
        DropCount++;
    }else
    {
        DropCount = 0;
    }
    if(DropCount > 100)
    {
        Reconnect();
        DropCount = 0;
    }
    return numR;
}

uint8_t GloveWifi::SendDataToGlove(uint8_t * buf, uint16_t size)
{
    return socket->send((char *)buf, size);
}

        