#include "GestureRecognition.h"
#include "mbed.h"

#define MAX_COUNT 10 

GestureRecognition::GestureRecognition(){ 
    counter = 0;  
    secondCounter = 0;
}

GestureRecognition::~GestureRecognition(){
}


//Finger data is given in range of 0-150. 150 = finger is bent. 0 = finger is straight out. 

CubeUpdateParameters GestureRecognition::sensorToGesture(Glove data){
    CubeUpdateParameters returnParams; 
    returnParams.size = 0;
    returnParams.deltaX = 0;
    returnParams.deltaY = 0;
    returnParams.deltaZ = 0;
    int fingerThreshold = 500;
    int thumbThreshold = 200;
    if (++counter >= MAX_COUNT) { 
        returnParams.size = 4;
        secondCounter++;
        bool fBent[5];
        for (int iter = 0; iter < 5; iter++) {
            if (iter < 4)
                fBent[iter] = (data.fingers[iter] > fingerThreshold);
            else
                fBent[iter] = (data.fingers[iter] > thumbThreshold);
        }
        if (secondCounter > 3) {
            //printf("%d %d %d %d %d\r\n", fBent[0], fBent[1], fBent[2], fBent[3], fBent[4]);
            secondCounter = 0;
        }
        // Change size based on finger gesture    
        if (fBent[0] && fBent[1] && fBent[2] && (!fBent[3]) && fBent[4]) 
            returnParams.size = 2; 
        else if (fBent[0] && fBent[1] && (!fBent[2]) && (!fBent[3]) && fBent[4]) 
            returnParams.size = 4; 
        else if (fBent[0] && (!fBent[1]) && (!fBent[2]) && (!fBent[3]) && fBent[4]) 
            returnParams.size = 6; 
        else if ((!fBent[0]) && (!fBent[1]) && (!fBent[2]) && (!fBent[3]) && fBent[4]) 
            returnParams.size = 8;
        //Change color    
        else if (fBent[0] && (!fBent[1]) && (!fBent[2]) && (!fBent[3]) && (!fBent[4]))
            returnParams.hue = 25.0/100.0;    
        else if (fBent[0] && fBent[1] && (!fBent[2]) && (!fBent[3]) && (!fBent[4]))
            returnParams.hue = 75.0/100.0;      
        else if (fBent[0] && fBent[1] && fBent[2] && (!fBent[3]) && (!fBent[4]))
            returnParams.hue = 100.0/100.0;  
        
        //Change position. Roll, pitch, and yaw are given as degrees. 
        if (data.roll > 10 )
            returnParams.deltaX = -1;
        else if (data.roll < -10)
            returnParams.deltaX = 1;
        if (data.pitch > 10)
            returnParams.deltaZ = 1;
        else if (data.pitch < -10)
            returnParams.deltaZ = -1;
        if (data.yaw > 10)
            returnParams.deltaY = -1;
        else if (data.yaw + 360 > 10 && data.yaw < 0)
            returnParams.deltaY = 1;
           
        counter = 0;
            
    } 
        return returnParams; 
}