#include "mbed.h"
#include "SRF05.h"
#include "fonction.h"
#define ARRET 0
#define ROULE 1


SRF05 SRF(p13,p14);
DigitalOut SensG(p12);//Sens Gauche
DigitalOut SensD(p11);//Sens Droite
PwmOut PWMG(p23); //Sortie moteur gauche
PwmOut PWMD(p22); //Sortie moteur droit
DigitalIn BpD(p29);
DigitalIn BpG(p30);
AnalogIn CPTG (p20);
AnalogIn CPTD (p19);
AnalogIn BAT (p15);

float srfa,srfc;

int main()
{

    PWMG.period_us(100);
    PWMD.period_us(100);
    int /*J,S,*/etat=0/*,bpg,bpd*/;
    BpD.mode(PullUp);
    BpG.mode(PullUp);

    while(1) {
        srfa=SRFA.read();
        srfc=SRFC.read();

        switch(etat) {
            case 0 :
                if(srfc<=5) etat=2;
                if(srfc>=10) etat=1;
                if(srfc<=5 && srfa<=5) etat=3;
                break;
            case 1 : //ZIG
                if(srfc<=5) etat=2;
                if(srfc<=5 && srfa<=5) etat=3;
                break;
            case 2 : //ZAG
                if(srfc>=10) etat=1;
                if(srfc<=5 && srfa<=5) etat=3;
                break;
            case 3 ://MUR
                if(srfa>=10) etat=0;
                break;
        }

        switch(etat) {

            case 0 :
                roule_motgauche(0,60);
                roule_motdroit(0,60);                                  // Roule
                break;
            case 1 :
                roule_motgauche(0,65);
                roule_motdroit(0,60);
                break;
            case 2 :
                roule_motgauche(0,60);
                roule_motdroit(0,65);
                break;
            case 3 :
                roule_motgauche(0,50);
                roule_motdroit(0,70);
                break;
        }

    }

}


