#include "mbed.h"


#define max7219_reg_noop         0x00
#define max7219_reg_digit0       0x01
#define max7219_reg_digit1       0x02
#define max7219_reg_digit2       0x03
#define max7219_reg_digit3       0x04
#define max7219_reg_digit4       0x05
#define max7219_reg_digit5       0x06
#define max7219_reg_digit6       0x07
#define max7219_reg_digit7       0x08
#define max7219_reg_decodeMode   0x09
#define max7219_reg_intensity    0x0a
#define max7219_reg_scanLimit    0x0b
#define max7219_reg_shutdown     0x0c
#define max7219_reg_displayTest  0x0f




Serial pc(USBTX, USBRX); // tx, rx this is for the data to be sent via the usb port to the computer
Ticker pulse;
AnalogIn pulse_in(PTB0);
AnalogOut o(PTE30);
DigitalOut led(PTD5);
float xi,ypast,y,sum;//absolute max
float alpha=0.8;
int no;
bool first=true;
void get_pulse()
{
    xi=(float)pulse_in;
    //noise reduction algorithm
    if(!first)//noise filtering procedure
    {
        y=alpha*xi+ (1-alpha)*ypast;
    }
    else 
        first=false;
    if(y>0.6)//make the led blink to the heartbeat when signal reaches a certain high region, it will stay lit till the signal decreases below that value
    {
        led=1;
    }
    else
    {
        led=0;
    }
    //pc.printf("%.3f, %.3f\n",xi,y);
    ypast=y;sum+=y;no++;
}




#define LOW 0
#define HIGH 1

SPI max72_spi(PTD2, NC, PTD1);
DigitalOut load(PTD0); //will provide the load signal


char  heart[8] = {0x00,0x36,0x7f,0x7f,0x3e,0x1c,0x08,0x00};


//DISPLAY FUNCTIONS DO NOT TOUCH

void write_to_max( int reg, int col)
{
    load = LOW;            // begin
    max72_spi.write(reg);  // specify register
    max72_spi.write(col);  // put data
    load = HIGH;           // make sure data is loaded (on rising edge of LOAD/CS)
}

//writes 8 bytes to the display  
void pattern_to_display(char *testdata){
    int cdata; 
    for(int idx = 0; idx <= 7; idx++) {
        cdata = testdata[idx]; 
        write_to_max(idx+1,cdata);
    }
} 
 

void setup_dot_matrix ()
{
    // initiation of the max 7219
    // SPI setup: 8 bits, mode 0
    max72_spi.format(8, 0);
     
  
  
       max72_spi.frequency(100000); //down to 100khx easier to scope ;-)
      

    write_to_max(max7219_reg_scanLimit, 0x07);
    write_to_max(max7219_reg_decodeMode, 0x00);  // using an led matrix (not digits)
    write_to_max(max7219_reg_shutdown, 0x01);    // not in shutdown mode
    write_to_max(max7219_reg_displayTest, 0x00); // no display test
    for (int e=1; e<=8; e++) {    // empty registers, turn all LEDs off
        write_to_max(e,0);
    }
   // maxAll(max7219_reg_intensity, 0x0f & 0x0f);    // the first 0x0f is the value you can set
     write_to_max(max7219_reg_intensity,  0x08);     
 
}

void clear(){
     for (int e=1; e<=8; e++) {    // empty registers, turn all LEDs off
        write_to_max(e,0);
    }
}

//END OF DISPLAY FUNCTIONS

void splash_screen()
{
    setup_dot_matrix ();      /* setup matric */
    pattern_to_display(heart);
    wait_ms(1000);
    heart[7]=0x01;heart[0]=0x01;
    for(int i=1;i<=8;++i)
    {
        pattern_to_display(heart);
        wait(0.2);
        heart[7]<<=1;
        heart[7]|=1;
        heart[0]=heart[7];
    }
    for(int i=1;i<=6;++i)
    {
        heart[i]=~heart[i];
        }
    pattern_to_display(heart);
    wait(1.6);
    clear();
}

int main()
{
    pulse.attach(&get_pulse,0.0125);//attach the interrupt thing so it starts the ISR every 0.0125 s
    splash_screen();//wait for the pulse to be stable by showing stuff on the display so the user is happy knowing he is gay
    while(1)
    {
        o=(sum*100)/no-1;//attempt at doing the running average which at the moment does not work
    }
}
