#include "mbed.h"
#include "rtos.h"
/* Mail */
typedef struct {
    unsigned char planet;
    uint32_t hours; /* AD result of measured voltage */
    uint32_t minutes; /* AD result of measured current */
    uint32_t seconds; /* A counter value               */
} clock_real, * ap_clock_real;

Mail<clock_real, 9> clock_box;

//*****************************************************tierra**********************************************
void clock_earth (void const *args)
{
    clock_real reloj;
    ap_clock_real ap_reloj;
    ap_reloj=&reloj;
    reloj.seconds=0;
    reloj.minutes=0;
    reloj.hours=0;
    reloj.planet='T';

    while (true) {

        clock_real *tigtag= clock_box.alloc();
        reloj.seconds++;
        if(reloj.seconds>=60) {
            reloj.seconds=0;
            reloj.minutes++;
            if(reloj.minutes>=60) {
                reloj.minutes=0;
                reloj.hours++;
                if(reloj.hours>=24) {
                    reloj.hours=0;
                }
            }
        }
        clock_box.put(ap_reloj);
        Thread::wait(1000);
    }
}
//*****************************************************marte**********************************************
void clock_marte2 (void const *args)
{
    clock_real reloj;
    ap_clock_real ap_reloj;
    ap_reloj=&reloj;
    reloj.seconds=0;
    reloj.minutes=0;
    reloj.hours=0;
    reloj.planet='M';


    while (true) {

        clock_real *tigtag= clock_box.alloc();
        reloj.seconds++;
        if(reloj.seconds>=60) {
            reloj.seconds=0;
            reloj.minutes++;
            if(reloj.minutes>=60) {
                reloj.minutes=0;
                reloj.hours++;
                if(reloj.hours>=24) {
                    reloj.hours=0;
                }
            }
        }
        clock_box.put(ap_reloj);
        Thread::wait(1050);
    }
}

//*****************************************************venus**********************************************
void clock_venus (void const *args)
{
    clock_real reloj;
    ap_clock_real ap_reloj;
    ap_reloj=&reloj;
    reloj.seconds=0;
    reloj.minutes=0;
    reloj.hours=0;
    reloj.planet='V';

    while (true) {

        clock_real *tigtag= clock_box.alloc();
        reloj.seconds++;
        if(reloj.seconds>=60) {
            reloj.seconds=0;
            reloj.minutes++;
            if(reloj.minutes>=60) {
                reloj.minutes=0;
                reloj.hours++;
                if(reloj.hours>=24) {
                    reloj.hours=0;
                }
            }
        }
        clock_box.put(ap_reloj);
        Thread::wait(65000);
    }

}

int main (void)
{
    Thread t_e(clock_earth);
    Thread t_m(clock_marte2);
    Thread t_v(clock_venus);

    while (true) {
        osEvent evt = clock_box.get();
        if (evt.status == osEventMail) {
            clock_real *tigtag = (clock_real*)evt.value.p;
             printf("\nPlaneta: %c "   , tigtag->planet);
            printf(" Horas: %u "   , tigtag->hours);
            printf(" Minutos: %u "     , tigtag->minutes);
            printf(" Segundos: %u \r", tigtag->seconds);
            clock_box.free(tigtag);
        }
    }
}