#include "mbed.h"   //paqueteria de mbed

#define ON 0        //definimos on y off
#define OFF 1

DigitalOut led_G(LED_GREEN);  //definimos leds   verde, azul y rojo    
DigitalOut led_R(LED_RED);
DigitalOut led_B(LED_BLUE);

Serial pc(USBTX, USBRX); // tx, rx   comunicacion serial

InterruptIn button2(SW2);//PTC6      Se definen interrupciones para incrementar y decrementar el pwm
InterruptIn button3(SW3);//PTA4      con switch 1 y 2 

PwmOut motor(PTC10); //PTC10

enum color {NEGRO,ROJO,VERDE,AMBAR,AZUL,MAGENTA,CYAN,BLANCO};  // enumeramos los colores 

void led_RGB(color i); 
void incrementa();  
void decrementa();                                      //prototipos de la funcion Led RGB

float p=0;
float pant=0;




int main()
{
    button2.fall(&incrementa);  // cuando oprimes el boton incrementa el valor de p ancho de pulso
    button3.fall(&decrementa);  // cuando oprimes el boton decrementa el valor de p ancho de pulso
    pc.printf("Motor Apagado \n\r");


    while(1) {           // wait around, interrupts will interrupt this!

        motor=p;
    }
}


void led_RGB(color i)
{
    enum {RED=1,GREEN=2,BLUE=4};

    if(i&RED) led_R= ON;
    else led_R=OFF;
    if(i&GREEN) led_G= ON;
    else led_G=OFF;
    if(i&BLUE) led_B= ON;
    else led_B=OFF;

}

void incrementa()
{
    pant=p;            //Declarando estado anterior
    p=p+0.1f;          //Incremento de p en o.1
    led_RGB((color)0); //  
    pc.printf(" El Motor corre a:  %f\n\r",p);
    led_RGB((color)3);
    wait(0.3);
    led_RGB((color)0);

    if( p>=1) {             //declaramos que p llega a su maximo valor
        p=1;                // declaramos que p se quede en el maximo valor en 1
        pc.printf("EL motor al Maximo \n\r");
        led_RGB((color)5);
        led_R=OFF;
    }
}
void decrementa()
{
    pant=p;    
    p=p-0.1f;
    led_RGB((color)0);
    pc.printf(" El Motor corre a:  %f\n\r",p);
    led_RGB((color)3);
    wait(0.3);
    led_RGB((color)0);

    if( p<=0) {

        p=0;
        pc.printf("El motor esta apagado \n\r");
        led_RGB((color)1);
    }
}
