

#include "mbed.h"
#include "PID.h"
#include "controls.h"
#include "globals.h"

AnalogIn LL_t (PA_5);
AnalogIn L_t (PA_7);
AnalogIn R_t (PB_0);
AnalogIn RR_t (PB_1);

DigitalOut LL_e (PC_0);
DigitalOut L_e  (PC_1);
DigitalOut R_e  (PC_2);
DigitalOut RR_e (PC_3);

InterruptIn cM1_1(PA_5);  //interrupt from encoders
InterruptIn cM1_2(PB_3);
InterruptIn cM2_1(PA_0);
InterruptIn cM2_2(PA_1);

PwmOut M1F(PC_7);   //motor direction and speed control
PwmOut M1B(PC_6);
PwmOut M2F(PC_9);
PwmOut M2B(PC_8);
Serial pc(SERIAL_TX, SERIAL_RX);

volatile unsigned long counterM1 = 1; // counter for hall sensors
volatile unsigned long counterM2 = 1;

void incrementM1()
{
    ++counterM1;
}
void incrementM2()
{
    ++counterM2;
}

int main()
{
    M1B.write(0);
    M2B.write(0);
    M1F.write(0);
    M2F.write(0);
    
    LL_e=1;
    RR_e=1;

    cM1_1.rise(&incrementM1);
    cM1_1.fall(&incrementM1);
    cM1_2.rise(&incrementM1);
    cM1_2.fall(&incrementM1);

    cM2_1.rise(&incrementM2);
    cM2_1.fall(&incrementM2);
    cM2_2.rise(&incrementM2);
    cM2_2.fall(&incrementM2);

    move(.8, 1000000, forward, forward, &PID_e );

}






