#include "flood_fill.h"
maze::maze()
    :m_x(0),m_y(0),m_dir(up)
{
    for(int i=0; i<7; i++) {
        for(int j=0; j<7; j++) {
            m_cells[i][j].dist=14-i-j;
            m_cells[i][15-j].dist=14-i-j;
            m_cells[15-i][j].dist=14-i-j;
            m_cells[15-i][16-j].dist=14-i-j;
        }
    }
    for(int i=0; i< 16; i++) {
        m_cells[i][0].down_clear=false;
        m_cells[i][15].up_clear=false;
    }
    for(int i=0; i< 16; i++) {
        m_cells[0][i].left_clear=false;
        m_cells[15][i].right_clear=false;
    }

}

void maze::update_cells(int x, int y)
{
    int original_dist=m_cells[x][y].dist;
    bool value_found = false;
//find the smallest distance in cardinal direction m_cellss and make current m_cells dist into that
    if(m_cells[x][y].right_clear) {
        m_cells[x][y].dist = m_cells[x+1][y].dist + 1;
        value_found = true;
    }
    if((m_cells[x][y].up_clear && m_cells[x][y].dist > m_cells[x][y+1].dist + 1) || !value_found) {
        m_cells[x][y].dist = m_cells[x][y+1].dist + 1;
        value_found = true;
    }
    if(( m_cells[x][y].left_clear && m_cells[x][y].dist > m_cells[x-1][y].dist + 1) || !value_found) {
        m_cells[x][y].dist = m_cells[x-1][y].dist + 1;
        value_found = true;
    }
    if((m_cells[x][y].down_clear && m_cells[x][y].dist > m_cells[x][y-1].dist + 1) || !value_found) {
        m_cells[x][y].dist = m_cells[x][y-1].dist + 1;
        value_found = true;
    }

// if m_cells dist changed, need to adjust neighboring cell(s)
    if(original_dist!=m_cells[x][y].dist) {
        if(m_cells[x][y].up_clear && (m_cells[x][y].dist <= m_cells[x][y+1].dist))
            update_cells(x,y+1);
        if(m_cells[x][y].down_clear && (m_cells[x][y].dist <= m_cells[x][y-1].dist))
            update_cells(x,y-1);
        if(m_cells[x][y].right_clear && (m_cells[x][y].dist <= m_cells[x+1][y].dist))
            update_cells(x+1,y);
        if(m_cells[x][y].left_clear && (m_cells[x][y].dist <= m_cells[x-1][y].dist))
            update_cells(x-1,y);
    }
}