#include "mbed.h"

AnalogIn analog_value(PA_0);        // Entree analogique
PwmOut PWM(PC_7);                   // Broche D9 soit PC7

int main()
{
    // Declaration des variables
    float mesure;
    float tension;
    float t,th;
    
    PWM.period_ms(10);          // PWM à une période de 10 ms par defaut
    PWM.pulsewidth_ms(5);       // Duty cycle à 50%

    while(1) {

        mesure = analog_value.read();       // Assigne une valeur de 0.0 à 1.0 a mesure
        tension = mesure * 3.3;             // Conversion en V
        t = 10000 - (2000 * tension);       // Calcul de la periode selon la tension sur PA_0
        th = t / 2;                         // Calcul du temps haut
        PWM.period_us(t);                   // Definition de la nouvelle periode
        PWM.pulsewidth_us(th);              // Definition du nouveau temps haut
        wait_ms(100);
    }
}