#include "CmdTxDataRate.h"
#include "MTSText.h"
#include "MTSLog.h"


CmdTxDataRate::CmdTxDataRate()
: Command("Tx Data Rate", "AT+TXDR", "Set the Tx data rate for all channels", "US:(7-10|DR0-DR4|DR8-DR13)) EU:(7-12|DR0-DR7))") {
    _queryable = true;
}

uint32_t CmdTxDataRate::action(std::vector<std::string> args) {
    if (args.size() == 1)
        {
        CommandTerminal::Serial()->writef("DR%d - %s\r\n", CommandTerminal::Dot()->getTxDataRate(), CommandTerminal::Dot()->getDateRateDetails(CommandTerminal::Dot()->getTxDataRate()).c_str());
    } else if (args.size() == 2) {
        std::string dr = mts::Text::toUpper(args[1]);
        
        int datarate = -1;
        uint8_t i;

        int res = sscanf(dr.c_str(), "%d", &datarate);

        if (res == 0) {
            for (i = 0; i < 24; i++) {
                if (mDot::DataRateStr(i).find(dr) != std::string::npos) {
                    datarate = i;
                    break;
                }
            }
        } else {
            if (datarate > 6) {
                // Convert SF to DR

                if (CommandTerminal::Dot()->getFrequencyBand() == mDot::FB_US915) {
                    datarate = 10 - datarate;
                } else if (CommandTerminal::Dot()->getFrequencyBand() == mDot::FB_AU915) {
                    datarate = 10 - datarate;
                } else {
                    datarate = 12 - datarate;
                }
            }
        }

        if (CommandTerminal::Dot()->setTxDataRate(datarate) != mDot::MDOT_OK) {
            CommandTerminal::setErrorMessage(CommandTerminal::Dot()->getLastError());
            return 1;
        }
    }

    return 0;
}

bool CmdTxDataRate::verify(std::vector<std::string> args) {
    if (args.size() == 1)
        return true;

    if (args.size() == 2) {
        std::string dr = mts::Text::toUpper(args[1]);

        uint8_t i;
        int datarate = -1;

        int res = sscanf(dr.c_str(), "%d", &datarate);

        if (res == 0) {
            for (i = 0; i < 24; i++) {

                if (mDot::DataRateStr(i).find(dr) != std::string::npos) {
                    uint8_t _dr = i;

                    if (_dr > 15) {
                        _dr = 12 + (mDot::SF_12 - _dr);

                        if (CommandTerminal::Dot()->getFrequencyBand() == mDot::FB_EU868) {
                            if (_dr == mDot::SF_7H) {
                                _dr = mDot::DR6;
                            } else if (_dr == mDot::SF_FSK) {
                                _dr = mDot::DR7;
                            } else {
                                _dr = 12 - _dr;
                            }
                        } else if (CommandTerminal::Dot()->getFrequencyBand() == mDot::FB_AU915) {
                            _dr = 10 - _dr;
                        } else {
                            _dr = 10 - _dr;
                        }
                    }

                    datarate = _dr;
                    break;
                }
            }
        } else {

            if ((CommandTerminal::Dot()->getFrequencyBand() == mDot::FB_US915) && datarate > 10) {
                datarate = -1;
            } else if (datarate > 12) {
                datarate = -1;
            } else if (datarate > 6) {
                // Convert SF to DR
                if (CommandTerminal::Dot()->getFrequencyBand() == mDot::FB_US915) {
                    datarate = 10 - datarate;
                } else if (CommandTerminal::Dot()->getFrequencyBand() == mDot::FB_AU915) {
                    datarate = 10 - datarate;
                } else {
                    datarate = 12 - datarate;
                }
            }
        }

        if (CommandTerminal::Dot()->getFrequencyBand() == mDot::FB_US915) {
            // DR8-13 used for P2P modes
            if (datarate < 0 || datarate > 13 || (datarate >= 5 && datarate <= 7)) {
                CommandTerminal::setErrorMessage("Invalid data rate, expects (7-10|DR0-DR4|DR8-DR13)");
                return false;
            }
        } else if (CommandTerminal::Dot()->getFrequencyBand() == mDot::FB_AU915) {
            // DR8-13 used for P2P modes
            if (datarate < 0 || datarate > 13 || (datarate >= 5 && datarate <= 7)) {
                CommandTerminal::setErrorMessage("Invalid data rate, expects (7-10|DR0-DR4|DR8-DR13)");
                return false;
            }
        } else {
            if (datarate < 0 || datarate > 7) {
                CommandTerminal::setErrorMessage("Invalid data rate, expects (7-12|DR0-DR7)");
                return false;
            }
        }

        return true;
    }

    CommandTerminal::setErrorMessage("Invalid arguments");
    return false;
}
