#include "CmdRxDataRate.h"

CmdRxDataRate::CmdRxDataRate()
:
  Command("Rx Data Rate", "AT+RXDR", "Set the Rx datarate, testing purposes only", "US:(7-10|DR0-DR4|DR8-DR13)) EU:(7-12|DR0-DR7))")
  
{
    _queryable = true;
}

uint32_t CmdRxDataRate::action(std::vector<std::string> args) {
    if (args.size() == 1) {
        CommandTerminal::Serial()->writef("%s\r\n", mDot::DataRateStr(CommandTerminal::Dot()->getRxDataRate()).c_str());
    }
    else if (args.size() == 2) {
        std::string dr = mts::Text::toUpper(args[1]);
        
        int datarate = 0;
        uint8_t i;

        int res = sscanf(dr.c_str(), "%d", &datarate);

        if (res == 0) {
            for (i = 0; i < 24; i++) {
                if (mDot::DataRateStr(i).find(dr) != std::string::npos) {
                    datarate = i;
                    break;
                }
            }
        } else {
            if (datarate > 6) {
                // Convert SF to DR
                if (CommandTerminal::Dot()->getFrequencyBand() == mDot::FB_US915 || CommandTerminal::Dot()->getFrequencyBand() == mDot::FB_AU915) {
                    datarate = 10 - datarate;
                } else {
                    datarate = 12 - datarate;
                }
            }
        }

        if (CommandTerminal::Dot()->setRxDataRate(datarate) != mDot::MDOT_OK) {
            CommandTerminal::setErrorMessage(CommandTerminal::Dot()->getLastError());;
            return 1;
        }
    }

    return 0;
}

bool CmdRxDataRate::verify(std::vector<std::string> args) {
    if (args.size() == 1)
        return true;

    if (args.size() == 2) {
        std::string dr = mts::Text::toUpper(args[1]);

        uint8_t i;
        int datarate = -1;

        int res = sscanf(dr.c_str(), "%d", &datarate);

        if (res == 0) {
            for (i = 0; i < 24; i++) {
                if (mDot::DataRateStr(i).find(dr) != std::string::npos) {
                    datarate = i;
                    break;
                }
            }
        } else {

            if ((CommandTerminal::Dot()->getFrequencyBand() == mDot::FB_US915  || CommandTerminal::Dot()->getFrequencyBand() == mDot::FB_AU915 ) && datarate > 10) {
                datarate = -1;
            } else if (CommandTerminal::Dot()->getFrequencyBand() == mDot::FB_EU868 && datarate > 12) {
                datarate = -1;
            } else if (datarate > 6) {
                // Convert SF to DR
                if (CommandTerminal::Dot()->getFrequencyBand() == mDot::FB_US915 || CommandTerminal::Dot()->getFrequencyBand() == mDot::FB_AU915) {
                    datarate = 10 - datarate;
                } else {
                    datarate = 12 - datarate;
                }
            }
        }

        if (CommandTerminal::Dot()->getFrequencyBand() == mDot::FB_US915 || CommandTerminal::Dot()->getFrequencyBand() == mDot::FB_AU915) {
            // DR8-13 used for P2P modes
            if (datarate < 0 || datarate > 13 || (datarate >= 5 && datarate <= 7)) {
                CommandTerminal::setErrorMessage("Invalid data rate, expects (7-10|DR0-DR4|DR8-DR13)");
                return false;
            }
        } else {
            if (datarate < 0 || datarate > 7) {
                CommandTerminal::setErrorMessage("Invalid data rate, expects (7-12|DR0-DR7)");
                return false;
            }
        }

        return true;
    }

    CommandTerminal::setErrorMessage("Invalid arguments");
    return false;
}
