#include "CmdTxFrequency.h"
#include <climits>


CmdTxFrequency::CmdTxFrequency() :
    Command("Tx Frequency", "AT+TXF", "Set Tx frequency", "US:(0,902000000-928000000), AU:(0, 915000000-928000000), EU:(0,863000000-870000000)") {
    _queryable = true;
}

uint32_t CmdTxFrequency::action(std::vector<std::string> args)
{
    if (args.size() == 1)
    {
        CommandTerminal::Serial()->writef("%lu\r\n", CommandTerminal::Dot()->getTxFrequency());
    }
    else if (args.size() == 2)
    {
        int frequency = 0;

        sscanf(args[1].c_str(), "%d", &frequency);
        if (CommandTerminal::Dot()->setTxFrequency(frequency) != mDot::MDOT_OK)
        {
            CommandTerminal::setErrorMessage(CommandTerminal::Dot()->getLastError());;
            return 1;
        }
    }

    return 0;
}

bool CmdTxFrequency::verify(std::vector<std::string> args)
{
    if (args.size() == 1)
        return true;

    if (args.size() == 2)
    {
        int frequency = ULONG_MAX;
        if (sscanf(args[1].c_str(), "%d", &frequency) != 1) {
            CommandTerminal::setErrorMessage("Invalid argument");
            return false;
        }

        if (frequency != 0 && (frequency < int(CommandTerminal::Dot()->getMinFrequency()) || frequency > int(CommandTerminal::Dot()->getMaxFrequency()))) {
            if (CommandTerminal::Dot()->getFrequencyBand() == mDot::FB_EU868)
                CommandTerminal::setErrorMessage("Invalid frequency, expects (0,863000000-870000000)"); 
            else if (CommandTerminal::Dot()->getFrequencyBand() == mDot::FB_AU915)
                CommandTerminal::setErrorMessage("Invalid frequency, expects (0,915000000-928000000)");
            else
                CommandTerminal::setErrorMessage("Invalid frequency, expects (0,902000000-928000000)");

            return false;
        }

        return true;
    }

    CommandTerminal::setErrorMessage("Invalid arguments");
    return false;
}

