//------------------------------------------------------------------//
//Supported MCU:   RZ/A1H
//File Contents:   Servo Control (GR-PEACH version on the Micon Car)
//Version number:  Ver.1.00
//Date:            2016.01.20
//Copyright:       Renesas Electronics Corporation
//------------------------------------------------------------------//

//This program supports the following boards:
//* GR-PEACH(E version)
//* Motor drive board Ver.5
//* Camera module (SC-310)

//Include
//------------------------------------------------------------------//
#include "mbed.h"
#include "iodefine.h"

//Define
//------------------------------------------------------------------//
//Servo PWM cycle
#define     SERVO_PWM_CYCLE     33332   /* SERVO PWM period         */
                                        /* 16ms   P0φ/16 = 0.48us   */
#define     SERVO_CENTER        3124    /* 1.5ms / 0.48us - 1 = 3124*/
#define     HANDLE_STEP         18      /* 1 degree value           */

//Constructor
//------------------------------------------------------------------//
Ticker      interrput;

//Prototype
//------------------------------------------------------------------//
void init_MTU2_PWM_Servo( void );       /* Initialize PWM functions */
void intTimer( void );                  /* Interrupt fanction       */
void timer( unsigned long timer_set );
void handle( int angle );

//Globle
//------------------------------------------------------------------//
volatile unsigned long  cnt_timer;      /* Used by timer function   */

//Main
//------------------------------------------------------------------//
int main( void )
{
    /* Initialize MCU functions */
    init_MTU2_PWM_Servo();
    interrput.attach(&intTimer, 0.001);

    while(1) {
        handle( 0 );
        timer( 1000 );
        handle( 30 );
        timer( 1000 );
        handle( 0 );
        timer( 1000 );
        handle( -30 );
        timer( 1000 );
    }
}

//Initialize MTU2 PWM functions
//------------------------------------------------------------------//
//MTU2_0
//PWM mode 1
//TIOC0A(P4_0) :Servo-motor
//------------------------------------------------------------------//
void init_MTU2_PWM_Servo( void )
{
    /* Port setting for S/W I/O Contorol */
    /* alternative mode     */

    /* MTU2_0 (P4_0)        */
    GPIOPBDC4   = 0x0000;               /* Bidirection mode disabled*/
    GPIOPFCAE4 &= 0xfffe;               /* The alternative function of a pin */
    GPIOPFCE4  &= 0xfffe;               /* The alternative function of a pin */
    GPIOPFC4   |= 0x0001;               /* The alternative function of a pin */
                                        /* 2nd alternative function/output   */
    GPIOP4     &= 0xfffe;               /*                          */
    GPIOPM4    &= 0xfffe;               /* p4_0:output              */
    GPIOPMC4   |= 0x0001;               /* P4_0:double              */

    /* Mosule stop 33(MTU2) canceling */
    CPGSTBCR3  &= 0xf7;

    /* MTU2_0 (Motor PWM) */
    MTU2TCR_0   = 0x22;                 /* TCNT Clear(TGRA), P0φ/16 */
    MTU2TIORH_0 = 0x52;                 /* TGRA L>H, TGRB H>L       */
    MTU2TMDR_0  = 0x32;                 /* TGRC and TGRD = Buff-mode*/
                                        /* PWM-mode1                */
    MTU2TCNT_0  = 0;                    /* TCNT0 Set 0              */
    MTU2TGRA_0  = MTU2TGRC_0 = SERVO_PWM_CYCLE;
                                        /* PWM-Cycle(16ms)          */
    MTU2TGRB_0  = MTU2TGRD_0 = 0;       /* Servo-motor(P4_0)        */
    MTU2TSTR   |= 0x01;                 /* TCNT_0 Start             */
}

//Interrupt Timer
//------------------------------------------------------------------//
void intTimer( void )
{
    cnt_timer++;
}

//Timer fanction
//------------------------------------------------------------------//
void timer( unsigned long timer_set )
{
    cnt_timer = 0;
    while( cnt_timer < timer_set );
}

//Handle fanction
//------------------------------------------------------------------//
void handle( int angle )
{
    /* When the servo move from left to right in reverse, replace "-" with "+" */
    MTU2TGRD_0 = SERVO_CENTER - angle * HANDLE_STEP;
}

//------------------------------------------------------------------//
// End of file
//------------------------------------------------------------------//