//------------------------------------------------------------------//
//Supported MCU:   RZ/A1H
//File Contents:   Serial Communication (GR-PEACH version)
//Version number:  Ver.1.00
//Date:            2016.01.18
//Copyright:       Renesas Electronics Corporation
//------------------------------------------------------------------//

//Include
//------------------------------------------------------------------//
#include "mbed.h"

//Constructor
//------------------------------------------------------------------//
Serial      pc(USBTX, USBRX);
DigitalOut  LED_G(LED2);

//Main
//------------------------------------------------------------------//
int main( void )
{
    int     i, ret;

    /* Initialize MCU functions */
    pc.baud(9600);

    pc.printf( "Hello World!\n" );

    while(1) {
        pc.printf( "Input data : " );
        ret = pc.scanf( "%d", &i );
        if( ret == 1 ) {
            pc.printf( "Get data : %d\n", i );
            LED_G = 1;
        } else {
            pc.printf( "Data Error!!\n" );
            pc.scanf( "%*[^\n]" );
        }
    }
}

//------------------------------------------------------------------//
// End of file
//------------------------------------------------------------------//