//------------------------------------------------------------------//
//Supported MCU:   RZ/A1H
//File Contents:   Motor Control (GR-PEACH version on the Micon Car)
//Version number:  Ver.1.00
//Date:            2016.09.09
//Copyright:       Renesas Electronics Corporation
//                 Hitachi Document Solutions Co., Ltd.
//------------------------------------------------------------------//
 
//This program supports the following boards:
//* GR-PEACH(E version)
//* Motor drive board Ver.5
//* Camera module (SC-310)
 
//Include
//------------------------------------------------------------------//
#include "mbed.h"
#include "iodefine.h"
#include "PwmOutResetSync.h"
 
//Define
//------------------------------------------------------------------//
//Motor speed
#define     MAX_SPEED           85      /* motor()  set: 0 to 100   */
 
//Constructor
//------------------------------------------------------------------//
Ticker      interrput;
DigitalOut  Left_motor_signal(P4_6);
DigitalOut  Right_motor_signal(P4_7);
PwmOutResetSync pwm_l(P4_4);
PwmOutResetSync pwm_r(P4_5);
 
//Prototype
//------------------------------------------------------------------//
void intTimer( void );                  /* Interrupt fanction       */
void timer( unsigned long timer_set );
void motor( int accele_l, int accele_r );
void MTU2_PWM_Motor_Stop( void );
void MTU2_PWM_Motor_Start( void );
 
//Globle
//------------------------------------------------------------------//
volatile unsigned long  cnt_timer;      /* Used by timer function   */
 
//Main
//------------------------------------------------------------------//
int main( void )
{
    /* Initialize MCU functions */
    PwmOutResetSync::period(0.001);   /* Other notation: "pwm_l.period_ms(1);" or "pwm_r.period_ms(1);" */
    interrput.attach(&intTimer, 0.001);

    while(1) {
        motor( 100, 0 );
        timer( 1000 );
        motor( 0, 80 );
        timer( 1000 );
        motor( -60, 0 );
        timer( 1000 );
        motor( 0, -40 );
        timer( 1000 );
        motor( 0, 0 );
        timer( 1000 );
    }
}

//Interrupt Timer
//------------------------------------------------------------------//
void intTimer( void )
{
    cnt_timer++;
}

//Timer fanction
//------------------------------------------------------------------//
void timer( unsigned long timer_set )
{
    cnt_timer = 0;
    while( cnt_timer < timer_set );
}

//motor speed control(PWM)
//Arguments: motor:-100 to 100
//Here, 0 is stop, 100 is forward, -100 is reverse
//------------------------------------------------------------------//
void motor( int accele_l, int accele_r )
{
    accele_l = ( accele_l * MAX_SPEED ) / 100;
    accele_r = ( accele_r * MAX_SPEED ) / 100;

    /* Left Motor Control */
    if( accele_l >= 0 ) {
        /* forward */
        Left_motor_signal = 0;
        pwm_l.write((float)accele_l / 100);    /* Other notation: "pwm_l = (float)accele_l / 100;" */
    } else {
        /* reverse */
        Left_motor_signal = 1;
        pwm_l.write((float)(-accele_l) / 100); /* Other notation: "pwm_l = (float)(-accele_l) / 100;" */
    }
 
    /* Right Motor Control */
    if( accele_r >= 0 ) {
        /* forward */
        Right_motor_signal = 0;
        pwm_r.write((float)accele_r / 100);    /* Other notation: "pwm_r = (float)accele_r / 100;" */
    } else {
        /* reverse */
        Right_motor_signal = 1;
        pwm_r.write((float)(-accele_r) / 100); /* Other notation: "pwm_r = (float)(-accele_r) / 100;" */
    }
}

// MTU2 PWM Motor Stop
//------------------------------------------------------------------//
void MTU2_PWM_Motor_Stop( void )
{
    MTU2TSTR   &= 0xbf;                 /* TCNT_4 Stop              */
    MTU2TOER   &= 0xf9;                 /* TIOC4A,4B enabled output */
    GPIOPMC4   &= 0xffcf;               /* P4_4,P4_5 : port mode    */
}

// MTU2 PWM Motor Start
//------------------------------------------------------------------//
void MTU2_PWM_Motor_Start( void )
{
    GPIOPMC4   |= 0x0030;               /* P4_4, P4_5 : double mode */
    MTU2TOER   |= 0xc6;                 /* TIOC4A,4B enabled output */
    MTU2TCNT_3  = MTU2TCNT_4 = 0;       /* TCNT3,TCNT4 Set 0        */
    MTU2TSTR   |= 0x40;                 /* TCNT_3 Start             */
}

//------------------------------------------------------------------//
// End of file
//------------------------------------------------------------------//