//------------------------------------------------------------------//
//Supported MCU:   RZ/A1H
//File Contents:   Interrupt Timer LED (GR-PEACH version)
//Version number:  Ver.1.00
//Date:            2016.01.18
//Copyright:       Renesas Electronics Corporation
//------------------------------------------------------------------//

//Include
//------------------------------------------------------------------//
#include "mbed.h"

//Constructor
//------------------------------------------------------------------//
Ticker      interrput;
DigitalOut  LED_R(LED1);
DigitalOut  LED_G(LED2);
DigitalOut  LED_B(LED3);

//Prototype
//------------------------------------------------------------------//
void intTimer( void );                  /* Interrupt fanction       */
void timer( unsigned long timer_set );

//Globle
//------------------------------------------------------------------//
volatile unsigned long  cnt_timer;      /* Used by timer function   */

//Main
//------------------------------------------------------------------//
int main( void )
{
    /* Initialize MCU functions */
    interrput.attach(&intTimer, 0.001);
 
    while(1) {
        LED_R = 1;
        timer( 1000 );
        LED_R = 0;
        timer( 1000 );
    }
}

//Interrupt Timer
//------------------------------------------------------------------//
void intTimer( void )
{
    cnt_timer++;
}

//Timer fanction
//------------------------------------------------------------------//
void timer( unsigned long timer_set )
{
    cnt_timer = 0;
    while( cnt_timer < timer_set );
}

//------------------------------------------------------------------//
// End of file
//------------------------------------------------------------------//