#include "mbed.h"

//------------------------------------
// Hyperterminal configuration
// 9600 bauds, 8-bit data, no parity
//------------------------------------

Serial pc(SERIAL_TX, SERIAL_RX);

DigitalOut myled(LED1);
DigitalOut zas(PA_13);

InterruptIn aparaty[10] = {PC_8, PC_6, PC_5, PA_12, PA_11, PB_12, PB_11, PB_2, PB_1, PB_15};

int licznik[10];

void trigger0() { licznik[0]++; }
void trigger1() { licznik[1]++; }
void trigger2() { licznik[2]++; }
void trigger3() { licznik[3]++; }
void trigger4() { licznik[4]++; }
void trigger5() { licznik[5]++; }
void trigger6() { licznik[6]++; }
void trigger7() { licznik[7]++; }
void trigger8() { licznik[8]++; }
void trigger9() { licznik[9]++; }

int main()
{   
    int i;
        
    aparaty[0].rise(&trigger0);
    aparaty[1].rise(&trigger1);
    aparaty[2].rise(&trigger2);
    aparaty[3].rise(&trigger3);
    aparaty[4].rise(&trigger4);
    aparaty[5].rise(&trigger5);
    aparaty[6].rise(&trigger6);
    aparaty[7].rise(&trigger7);
    aparaty[8].rise(&trigger8);
    aparaty[9].rise(&trigger9);
    
    while(1) {
        if (zas == 0) {
            for (i = 0; i < 10; i++) {
                pc.printf("Aparat %i: %i\n\r", i+1, licznik[i]);
            }
            pc.printf("\n\r", i+1, licznik[i]);
            for (i = 0; i < 10; i++) {
                licznik[i] = 0;
            }
        }
        zas = !zas;
        myled = !myled;
        wait(5);
    }
}
