#include "mbed.h"
#include "tsi_sensor.h"

/* This defines will be replaced by PinNames soon */
#if defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
  #define ELEC0 9
  #define ELEC1 10
#elif defined (TARGET_KL05Z)
  #define ELEC0 9
  #define ELEC1 8
#else
  #error TARGET NOT DEFINED
#endif
void aplicar(void);
void espera(void);
void recibo(void);

Serial pc(USBTX, USBRX);
DigitalOut led_rojo(LED_RED);
DigitalOut led_verde(LED_GREEN);
DigitalOut led_azul(LED_BLUE);
PwmOut pwm(PTA5);
AnalogIn preset(A1);
DigitalIn entrada1(PTD0);
DigitalIn entrada2(PTB0);

TSIAnalogSlider tsi(ELEC0, ELEC1, 40);

char   c = '\0';
bool newdata = false;
int paso=0,verificacion=0,x=0;
int recibir[9];
float duty;
char pua[9];
void recibo(void)
{
    c=pc.getc();
    newdata=true;
    //printf("received\n\r");
}

void espera(void)
{
    if(newdata)
    {
        newdata=false;
        switch(paso)
        {
            case 0:
                if(c=='$')
                {
                    recibir[0]='$';
                    paso=1;
                }
                else
                {
                    paso=0;
                    for(x=0;x<=8;x++)
                    {
                        recibir[x]=0;
                    }
                }
                break;
            case 1:
                if(c=='W' || c=='R')
                {
                    if(c=='W')
                        recibir[1]='W';
                    if(c=='R')
                        recibir[1]='R';
                    paso=2;
                }
                else
                {
                    paso=0;
                    for(x=0;x<=8;x++)
                    {
                        recibir[x]=0;
                    }
                }
                break;
            case 2:
                if(c=='L' || c=='A' || c=='I' || c=='P')
                {
                    if(c=='L')
                    {
                        recibir[2]='L';
                    }
                    if(c=='A')
                    {
                        recibir[2]='A';
                    }
                    if(c=='I')
                    {
                        recibir[2]='I';
                    }
                    if(c=='P')
                        recibir[2]='P';
                    paso=3;
                }
                else
                {
                    paso=0;
                    for(x=0;x<=8;x++)
                    {
                        recibir[x]=0;
                    }
                }
                break;
             case 3:
                if((c>='0' && c<='9') || c=='R' || c=='G' || c=='B')
                {
                    if(c=='R')
                    {
                        recibir[3]='R';
                    }
                    if(c=='G')
                    {
                        recibir[3]='G';
                    }
                    if(c=='B')
                    {
                        recibir[3]='B';
                    }
                    if(c=='0' && (recibir[2]=='A' || recibir[2]=='I'))
                    {
                        recibir[3]='0';
                    }
                    if(c=='1'&& (recibir[2]=='A' || recibir[2]=='I'))
                    {
                        recibir[3]='1';
                    }
                    if((c>='0' && c<='9') && recibir[2]=='P')
                    {
                        recibir[3]=c;
                    }
                    paso=4;
                }
                else
                {
                    paso=0;
                    for(x=0;x<=8;x++)
                    {
                        recibir[x]=0;
                    }
                }
                break;
            case 4:
                if(recibir[1]=='W')
                {
                    if(c>='0' && c<='9')
                    {
                        if(c=='0' && recibir[2]=='L')
                        {
                            recibir[4]='0';
                            paso=10;
                        }
                        if(c=='1'&& recibir[2]=='L')
                        {
                            recibir[4]='1';
                            paso=10;
                        }
                        if(recibir[2]=='P')
                        {
                            recibir[4]=c;
                            paso=10;
                        }
                        
                    }
                    else
                    {
                        paso=0;
                        for(x=0;x<=8;x++)
                        {
                            recibir[x]=0;
                        }
                    }
                }
                if(recibir[1]=='R')
                {
                    recibir[4]=c;
                    paso=5;
                }
                break;
            case 5:
                recibir[5]=c;
                paso=6;
                break;
            case 6:
                recibir[6]=c;
                paso=7;
                break;
            case 7:
                if(c=='!')
                {
                    recibir[7]='!';
                    verificacion=(recibir[1]^recibir[2])^recibir[3];
                    //printf("La verificacion es %d\n\r",verificacion);
                    //printf("%c\n\r",(verificacion/100)+48);
                    //printf("%c\n\r",(verificacion/10-(verificacion/100)*10)+48);
                    //printf("%c\n\r",(verificacion-(verificacion/100)*100-((verificacion/10)-(verificacion/100)*10)*10)+48);
                    if(recibir[4]==(verificacion/100)+48 && recibir[5]==(verificacion/10-(verificacion/100)*10)+48 && recibir[6]==(verificacion-(verificacion/100)*100-((verificacion/10)-(verificacion/100)*10)*10)+48)
                    {
                        aplicar();
                        //printf("aplicated\n\r");
                    }
                    else
                    {
                        paso=0;
                        for(x=0;x<=8;x++)
                        {
                            recibir[x]=0;
                        }
                    }
                }
                else
                {
                    paso=0;
                    for(x=0;x<=8;x++)
                    {
                        recibir[x]=0;
                    }
                }
                break;
            case 10:
                recibir[5]=c;
                paso=11;
                break;
            case 11:
                recibir[6]=c;
                paso=12;
                break;
            case 12:
                recibir[7]=c;
                paso=13;
                break;
            case 13:
                if(c=='!')
                {
                    recibir[8]='!';
                    verificacion=((recibir[1]^recibir[2])^recibir[3])^recibir[4];
                    if(recibir[2]=='P')
                        verificacion=(recibir[1]^recibir[2]);
                    //printf("La verificacion es %d\n\r",verificacion);
                    //printf("%c\n\r",(verificacion/100)+48);
                    //printf("%c\n\r",(verificacion/10-(verificacion/100)*10)+48);
                    //printf("%c\n\r",(verificacion-(verificacion/100)*100-((verificacion/10)-(verificacion/100)*10)*10)+48);
                    if(recibir[5]==(verificacion/100)+48 && recibir[6]==(verificacion/10-(verificacion/100)*10)+48 && recibir[7]==(verificacion-(verificacion/100)*100-((verificacion/10)-(verificacion/100)*10)*10)+48)
                    {
                        aplicar();
                        //printf("aplicated\n\r");/
                    }
                    else
                    {
                        paso=0;
                        for(x=0;x<=8;x++)
                        {
                            recibir[x]=0;
                        }
                    }                 
                }
                else
                {
                    paso=0;
                    for(x=0;x<=8;x++)
                    {
                        recibir[x]=0;
                    }
                }
                break;
            default:
                break;
        }
    }
}

void aplicar(void)
{
    switch(verificacion)
    {
        case 120:
            //printf("%c%c%c%c%c%c%c%c%c\n\r",recibir[0],recibir[1],recibir[2],recibir[3],recibir[4],recibir[5],recibir[6],recibir[7],recibir[8]);
            //printf("Led Red ON\n\r");
            led_rojo=0;
            paso=0;
            for(x=0;x<=8;x++)
            {
                recibir[x]=0;
            }
            break;
        case 121:
            //printf("%c%c%c%c%c%c%c%c%c\n\r",recibir[0],recibir[1],recibir[2],recibir[3],recibir[4],recibir[5],recibir[6],recibir[7],recibir[8]);
            //printf("Led Red OFF\n\r");
            led_rojo=1;
            paso=0;
            for(x=0;x<=8;x++)
            {
                recibir[x]=0;
            }
            break;
        case 109:
            //printf("%c%c%c%c%c%c%c%c%c\n\r",recibir[0],recibir[1],recibir[2],recibir[3],recibir[4],recibir[5],recibir[6],recibir[7],recibir[8]);
            //printf("Led Green ON\n\r");
            led_verde=0;
            paso=0;
            for(x=0;x<=8;x++)
            {
                recibir[x]=0;
            }
            break;
        case 108:
            //printf("%c%c%c%c%c%c%c%c%c\n\r",recibir[0],recibir[1],recibir[2],recibir[3],recibir[4],recibir[5],recibir[6],recibir[7],recibir[8]);
            //printf("Led Green OFF\n\r");
            led_verde=1;
            paso=0;
            for(x=0;x<=8;x++)
            {
                recibir[x]=0;
            }
            break;
        case 104:
            //printf("%c%c%c%c%c%c%c%c%c\n\r",recibir[0],recibir[1],recibir[2],recibir[3],recibir[4],recibir[5],recibir[6],recibir[7],recibir[8]);
            //printf("Led Blue ON\n\r");
            led_azul=0;
            paso=0;
            for(x=0;x<=8;x++)
            {
                recibir[x]=0;
            }
            break;
        case 105:
            //printf("%c%c%c%c%c%c%c%c%c\n\r",recibir[0],recibir[1],recibir[2],recibir[3],recibir[4],recibir[5],recibir[6],recibir[7],recibir[8]);
            //printf("Led Blue OFF\n\r");
            led_azul=1;
            paso=0;
            for(x=0;x<=8;x++)
            {
                recibir[x]=0;
            }
            break;
        case 35:
            //printf("%c%c%c%c%c%c%c%c%c\n\r",recibir[0],recibir[1],recibir[2],recibir[3],recibir[4],recibir[5],recibir[6],recibir[7],recibir[8]);
            printf("%2.2f\n",preset.read());
            paso=0;
            for(x=0;x<=8;x++)
            {
                recibir[x]=0;
            }
            break;
        case 34:
            //printf("%c%c%c%c%c%c%c%c%c\n\r",recibir[0],recibir[1],recibir[2],recibir[3],recibir[4],recibir[5],recibir[6],recibir[7],recibir[8]);
            printf("%2.2f\n",tsi.readPercentage());
            paso=0;
            for(x=0;x<=8;x++)
            {
                recibir[x]=0;
            }
            break;
        case 43:
            //printf("%c%c%c%c%c%c%c%c%c\n\r",recibir[0],recibir[1],recibir[2],recibir[3],recibir[4],recibir[5],recibir[6],recibir[7],recibir[8]);
            printf("Entrada digital D0=%d\n",entrada1.read());
            paso=0;
            for(x=0;x<=8;x++)
            {
                recibir[x]=0;
            }
            break;
        case 42:
            //printf("%c%c%c%c%c%c%c%c%c\n\r",recibir[0],recibir[1],recibir[2],recibir[3],recibir[4],recibir[5],recibir[6],recibir[7],recibir[8]);
            printf("Entrada digital D1=%d\n",entrada2.read());
            paso=0;
            for(x=0;x<=8;x++)
            {
                recibir[x]=0;
            }
            break;
        case 76:
            //printf("%c%c%c%c%c%c%c%c%c\n\r",recibir[0],recibir[1],recibir[2],recibir[3],recibir[4],recibir[5],recibir[6],recibir[7],recibir[8]);
            printf("LED ROJO = %d\n",!led_rojo.read());
            paso=0;
            for(x=0;x<=8;x++)
            {
                recibir[x]=0;
            }
            break;
        case 89:
            //printf("%c%c%c%c%c%c%c%c%c\n\r",recibir[0],recibir[1],recibir[2],recibir[3],recibir[4],recibir[5],recibir[6],recibir[7],recibir[8]);
            printf("LED VERDE = %d\n",!led_verde.read());
            paso=0;
            for(x=0;x<=8;x++)
            {
                recibir[x]=0;
            }
            break;
        case 92:
            //printf("%c%c%c%c%c%c%c%c%c\n\r",recibir[0],recibir[1],recibir[2],recibir[3],recibir[4],recibir[5],recibir[6],recibir[7],recibir[8]);
            printf("LED AZUL = %d\n",!led_azul.read());
            paso=0;
            for(x=0;x<=8;x++)
            {
                recibir[x]=0;
            }
            break;
        case 7:
            //pwm
            
            pua[0]=recibir[3];
            pua[1]=recibir[4];
            duty=(((pua[0]-48)*10)+(pua[1]-48));
            duty=duty/100;
            pwm=duty;
            break;
        default:
            break;
    }
}

int main(void) 
{

    pc.attach(&recibo);
    led_rojo=1;
    led_verde=1;
    led_azul=1;
    while (true) 
    {
        espera();
    }
}