
#ifndef MAIN_H
#define MAIN_H

#define FW_VERSION  "V1.19" //  major revisions will be 1xx, 2xx, etc.

#define SKIP_SHIP_MODE      0  // 0=normal, 1=Test mode, where SHIP_MODE is skipped
#define UART_DEBUGGING      0  // if =1, put out debug info on the BLE_UART
#define ENABLE_LED          0  // if =1, enable the debug LED
//#define TEST_ON_NRF51_DK    0  // if =1, configure for running on nRF51-DK board

//#define DARK_SAMPLE_PERIOD  15  // During manufacturing, this determines how many seconds between light_sensor samples
//#define MIN_DARK_TIME_MIN   15  // Number of minutes the unit needs to be in the dark to go into SHIP_MODE

#define PERIODIC_TICK_SEC 1    // update rtc and run check cap rate
#define FAST_TICK_SEC     1    // update rtc and run check cap rate while in init and test mode
#define EOL_TICK_SEC      10   // update rtc and run check cap rate while in EOL mode

#define CAP_THRESHOLD_ON       42 // Cap on threshold.  Lower value means it triggers more easily
#define CAP_THRESHOLD_OFF      12 // Cap off threshold.  Higher value means it triggers more easily
#define CAP_THRESHOLD_OFF_EOL   25 // Cap off threshold for EOL to ensure bluetooth advertising - FTD 08212020

#define CAP_THRESHOLD_ON_INITIAL 25 // initial value of adaptive cap_off threshold (Must be higher than CAPTHRESHOLD_OFF)
#define CAP_THRESHOLD_ADAPT_RATE  192 // How fast the thresholf adapts. number 0 to 256. 256 means adapt immediately, 0 means no adapt.
#define CAP_THRESHOLD_PERCENT_OF_PEAK  218 // What fraction of the peak on-off cap reading is used for the threshold. %*256, so 85% is .85*256=218
#define CAP_THRESHOLD_OFF_PERCENT_OF_PEAK 59 // What fraction of the peak on-off cap reading is used for the threshold. %*256, so 85% is .85*256=218
#define CAP_THRESHOLD_TRIGGER_MULT 2 // Multiplier of cap off threshold used for EOL

#define CAP_SAMPLES    2 // Number of samples used for cap sensor average - FTD 08212020

//#define CAP_THRESHOLD       25 // adjusts the sensitivity of the cap sensor.  Lower value means it triggers more easily
//#define CAP_MAX_OFF_READING 1024 // if the off reading exceeds this limit, then reading is invalid and we use last valid reading

#define EOL_TIMEOUT_DAYS    31  // number of days after package is open before unit goes into EOL mode.
#define EOL_MAX_USES        120  // number of uses after which the unit goes into EOL mode.

#define CAP_LED_OFF_DELAY   0.0005 // delay (seconds) between turning on analog power and taking a cap sensor ADC reading with the sensor LED off - FTD 08212020
#define CAP_LED_ON_DELAY   0.0001 // delay (seconds) between turning on cap sensor LED and taking a cap sensor ADC reading - FTD 08212020

#define LIGHT_SENSE_PWRON_DELAY 0.200 // delay (seconds) between turning on light sense circuit, and taking an ADC reading.

#define GO_BACK_TO_SLEEP_DELAY  0  // When in SHIP_MODE_CHECK_CAP or SHIP_MODE_WAIT_CAP_OFF, we will not go back to sleep until the test is true this many times. (0 turns this feature off)
#define AMBIENT_DEBOUNCE        15  // Number of times the ambient sensor must show darkness in a row before going to sleep


extern void process_cmd(char * cmd);
extern void dataWasRead(void);

//******************************************************************************

#endif // #ifndef MAIN_H