//
// Hardware definitions for the Nordic SmartCap Board
//
// SPG 12/13/2016
//

#ifndef __HW
#define __HW

#if 1
    // This is used when running on the real SartCap board
    // Digital I/O lines
    #define LIGHT_SENSE        p3      // Light Sense input
    #define LIGHT_SENSE_ENABLE p5      // Enable Light Sense Circuit
    
    #define CAP_SENSE_LED      p2      // Enable Cap Sense LED
    #define VDD_ENABLE         p0      // Analog voltage on when hi
    #define LED                p18     // LED on when hi
    
    // ADC defines
    #define ADC_CHAN_BATTERY    0 /* no I/O pin, done internally */
    #define ADC_CHAN_CAP_SENSE  2 /* p1 or Analog2 */
    #define ADC_CHAN_LIGHT_SENSE 4
#else
    // this is used when simulating on a nRF51_DK
    // Digital I/O lines
    #define LIGHT_SENSE        p3      // Light Sense input
    #define LIGHT_SENSE_ENABLE p5      // Enable Light Sense Circuit
    
    #define CAP_SENSE_LED      p2      // Enable Cap Sense LED
    #define VDD_ENABLE         p0      // Analog voltage on when hi
    #define LED                p18     // LED on when hi
    
    // ADC defines
    #define ADC_CHAN_BATTERY    0 /* no I/O pin, done internally */
    #define ADC_CHAN_CAP_SENSE  2 /* p1 or Analog2 */
    #define ADC_CHAN_LIGHT_SENSE 4
#endif


void delay_ms(uint32_t volatile number_of_ms);

int adc_read(int chan, int num_readings);
int read_battery_voltage(void);

void set_rtc(uint32_t s);
void update_rtc(uint32_t s);

uint32_t read_clock(void);
//void init_clock(uint32_t s);
void set_time_offset(uint32_t s);
uint32_t read_time_correction(void);

char * uli2a(uint32_t num);
char * char2hex(char c);
char * char2hex(uint32_t n, int digits);

#endif // #ifndef __HW