// CCITT CRC-16
// Poly 0x1021
// Start 0xffff

#include <stdint.h>

uint16_t crc16(const unsigned char* data_p, uint32_t length)
{
    uint16_t x;
    uint16_t crc = 0xFFFF;

    while (length--){
        x = ((crc >> 8) ^ *data_p++) & 0xff;
        x ^= x>>4;
        crc = (crc << 8) ^ (x << 12) ^ (x <<5) ^ (x);
    }
    return crc; //& 0xffff;
}

