// Define memory addresses for flash storage
// SPG 02/27/2019
//

#ifndef MEM_H
#define MEM_H

#define LOG_SIZE     511 // number of log records

// Define memory specific items and addresses

static __INLINE uint16_t pstorage_flash_page_size()
{
  return (uint16_t)NRF_FICR->CODEPAGESIZE;
}

#define PSTORAGE_FLASH_PAGE_SIZE     pstorage_flash_page_size()          /**< Size of one flash page. */
#define PSTORAGE_FLASH_EMPTY_MASK    0xFFFFFFFF                          /**< Bit mask that defines an empty address in flash. */

#define BOOTLOADER_ADDRESS           (NRF_UICR->BOOTLOADERADDR)

static __INLINE uint32_t pstorage_flash_page_end()
{
   uint32_t bootloader_addr = BOOTLOADER_ADDRESS;
  
   return ((bootloader_addr != PSTORAGE_FLASH_EMPTY_MASK) ?
           (bootloader_addr/ PSTORAGE_FLASH_PAGE_SIZE) : NRF_FICR->CODESIZE);
}

// PSTORAGE is for the log
// FLAG is for flags such as: did we complete testing?

#define PSTORAGE_FLASH_PAGE_END     pstorage_flash_page_end()
#define PSTORAGE_NUM_OF_PAGES       4                                                           /**< Number of flash pages allocated for the pstorage. 2 per 256 log entries. */
#define PSTORAGE_DATA_START_ADDR    ((PSTORAGE_FLASH_PAGE_END - PSTORAGE_NUM_OF_PAGES) \
                                    * PSTORAGE_FLASH_PAGE_SIZE)                                 /**< Start address for persistent data, configurable according to system requirements. */
#define PSTORAGE_DATA_END_ADDR      ((PSTORAGE_FLASH_PAGE_END) * PSTORAGE_FLASH_PAGE_SIZE)  /**< End address for persistent data, configurable according to system requirements. */

#define NV_BASE_ADDR                (PSTORAGE_DATA_START_ADDR - PSTORAGE_FLASH_PAGE_SIZE)
#define NV_TESTING_REQUIRED_ADDR    (NV_BASE_ADDR)
#define NV_NOT_EOL_ADDR             (NV_BASE_ADDR+4)
#define NV_NOT_IN_USE_ADDR          (NV_BASE_ADDR+8)

#define NV_TESTING_REQUIRED         (*((volatile uint32_t *) NV_TESTING_REQUIRED_ADDR))
#define NV_NOT_EOL                  (*((volatile uint32_t *) NV_NOT_EOL_ADDR))
#define NV_NOT_IN_USE               (*((volatile uint32_t *) NV_NOT_IN_USE_ADDR))

#define CRC_START_ADDR              (0x00000)
#define CRC_END_ADDR                (NV_BASE_ADDR - 1)

#endif
