#include "mbed.h"
#include "ble/BLE.h"
//#include "ble/services/UARTService.h"
#include "BLE_Stuff.h"
#include "hw.h"
#include "log.h"
#include "main.h"
#include "mem.h"
extern "C" {
    #include <nrf_nvmc.h>
}

#if LOG_SIZE * 8 > 1024 * PSTORAGE_NUM_OF_PAGES
    error, allocated flash not big enough for storing logs
#endif

extern bool log_enable; // initialized in main.cpp – DEW

// Counts number of records with non-zero time field
uint32_t log_get_num_records(void)
{
    uint32_t cnt = 0;
    log_struct *rec = (log_struct *)PSTORAGE_DATA_START_ADDR;
    
    while(rec < (log_struct *)PSTORAGE_DATA_END_ADDR)
    {
        if(rec->time == 0xffffffff) return cnt;
        cnt++;
        rec++;
    }
    return cnt;
}

// returns the number of records with code type
uint32_t log_code_count(event_t code)
{
    uint32_t cnt = 0;
    log_struct *rec = (log_struct *)PSTORAGE_DATA_START_ADDR;
    
    while(rec < (log_struct *)PSTORAGE_DATA_END_ADDR)
    {
        if(rec->time == 0xffffffff) return cnt;
        if(rec->code == code) cnt++;
        rec++;
    }
    return cnt;    
}

// returns address of 1st free record
static log_struct * get_free_record(void)
{
    log_struct *rec = (log_struct *)PSTORAGE_DATA_START_ADDR;
    
    while(rec < (log_struct *)PSTORAGE_DATA_END_ADDR)
    {
        if(rec->time == 0xffffffff) return rec;
        rec++;
    }
    return 0;
}

// can not be called while BLE is active
void log_erase(void)
{
    uint32_t addr = PSTORAGE_DATA_START_ADDR;
    
    //stop_radio_and_wait();
    
    while(addr < PSTORAGE_DATA_END_ADDR)
    {
        nrf_nvmc_page_erase(addr);
        addr += PSTORAGE_FLASH_PAGE_SIZE;
    }
}

/// Puts the requested log record out on the BLE UART.
void log_show(void)
{
    int cnt = log_get_num_records();
    log_struct * rec = (log_struct *)PSTORAGE_DATA_START_ADDR;
    
    BLE_UART_xmit("*Num Records=");
    BLE_UART_xmit(cnt);
    BLE_UART_xmit("\n");

    while(rec < (log_struct *)PSTORAGE_DATA_END_ADDR) {
        // show record
        uint32_t offset = read_time_correction();
        
        if(rec->time == 0xffffffff) break;

        // hex numbers
        BLE_UART_xmit("~");
        BLE_UART_xmit(char2hex(rec->time + offset, 8));
        BLE_UART_xmit(char2hex(rec->code));
        BLE_UART_xmit(char2hex(rec->d0));
        BLE_UART_xmit(char2hex(rec->d1));
        BLE_UART_xmit(char2hex(rec->d2));

        BLE_UART_xmit("\n");
        rec++;
        
        BLE &ble = BLE::Instance();
        ble.waitForEvent();
        wait(0.100);
    }
    
    //BLE_UART_xmit("Done!\n");
}

// add a new log entry
// 
void log_add(event_t code, char d0, char d1, char d2)
{ 
    uint32_t addr = (uint32_t)get_free_record();
    log_struct rec;
    
    if(addr == 0) return; // error, out of record storage
    
    rec.time = read_clock();
    rec.code = code;
    rec.d0 = d0;
    rec.d1 = d1;
    rec.d2 = d2;
    if(rec.time==0) rec.time++; // can't have a completely zero record.

//#if UART_DEBUGGING==0  // only do write to flash if not debugging w/BLE    
    if(log_enable)  // allow disabling of event logging through user command - DEW
    {   
        set_radio(false);
        wait(1.0);
        nrf_nvmc_write_words(addr, (uint32_t *)(&rec), 2);
    }
//#endif
}

/// Clear Non-Volatile Flag
void nv_clear(uint32_t addr)
{   
    uint32_t zero = 0;

//#if UART_DEBUGGING==0  // only do write to flash if not debugging w/BLE    
    set_radio(false);
    wait(1.0);
    nrf_nvmc_write_words(addr, (uint32_t *)(&zero), 1);
//#endif
}
