// Information Service with descriptors
//
// FFF0 - Service
// FFF1 - Battery

#include "mbed.h"
#include "ble/BLE.h"
#include "BLE_Stuff.h"
#include "infoService.h"
#include "main.h"
#if 0
const static uint16_t INFO_SERVICE_UUID = 0xFFF0;
const static uint16_t CHAR1_UUID = 0xFFF1;

#define CHAR1_NAME  "Half Battery Voltage"

char char1 = 0; // characteristic 1 inital value

// Define Characteristic 1 as a char
GattAttribute char1_Descr( BLE_UUID_DESCRIPTOR_CHAR_USER_DESC, (uint8_t *)CHAR1_NAME, strlen(CHAR1_NAME));
GattAttribute *char1_descriptors[] = {&char1_Descr};
ReadOnlyGattCharacteristic<char> char1Char(
    CHAR1_UUID,
    &char1,
    GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_EXTENDED_PROPERTIES + GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY + GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ,
    char1_descriptors,
    sizeof(char1_descriptors) / sizeof(GattAttribute*)
);

// Define the service of the above characteristics
GattCharacteristic *characteristics[] = {&char1Char};
GattService infoServicePtr(INFO_SERVICE_UUID, characteristics, sizeof(characteristics) / sizeof(GattCharacteristic *));

void updateBattValue(int voltage)
{
    static uint8_t halfv = voltage/2;
        if (ble.getGapState().connected) {
            ble.gattServer().write(char1Char.getValueHandle(), (uint8_t *)&halfv, sizeof(uint8_t));
            //ble.gattServer().write(rxCharacteristic.getValueAttribute().getHandle(), static_cast<const uint8_t *>(sendBuffer), sendBufferIndex);
        }
}
#endif
