
#ifndef LOG_H
#define LOG_H

#include <stdint.h>

typedef enum {
    EVENT_POWER = 0,            // RTC reset
    EVENT_CAP_ON =  1,
    EVENT_TEST_PASS = 2,
    EVENT_TEST_FAIL = 3,
    EVENT_EOL = 4,
    EVENT_WAKE_FROM_SHIP = 5,
    SMWD=6,
    SMWL=7,
    SMCC=8,
    SMWCO=9,

} event_t;


struct log_struct {
  uint32_t time; /* 32 bit seconds count */
  char code; 
  char d0;
  char d1;
  char d2;
};

void log_show(void);
void log_add(event_t code, char d0, char d1, char d2);
void log_erase(void);
uint32_t log_code_count(event_t code);
uint32_t log_get_num_records(void);
void nv_clear(uint32_t addr);

#endif // LOG_H