/**************************************************/
/* SDC21XX_Motor class : 
        - Contains :    RB, a Roboteq instance used to communicate with the SDC21XX controller
                        channel, range from 1 to 2, indicates the channel to which the motor is physically connected
                        reductor, ratio to use to determine the right angle of the motor
                        enc_resolution, number of ticks from the encoder per rotation of the motor, before the reductor

        - Methods :     1 constructor, containing a node identifier, a CAN pointer, the channel of the motor, the reductor and the encoder resolution,
                            the Roboteq object is instanciated during the instanciation of the SDC21XX_motor object
                        1 constructor, using a pointer to a Roboteq object instead of node identifier and CAN pointer
                        Getters and setters for every variable
                        Go- and GetAngle, to move the selected axis, using reductor and encoder resolution
                        SetVelocity, SetAcceleration, SetDeceleration, SetParameters, servant à régler la vitesse de rotation, l'accéleration et la déceleration
*/
/**************************************************/

/**************************************************/
/* Example programm
#include "mbed.h"
#include "SDC21XX_Motor.h"

CAN can(p30, p29);
Roboteq Robot_Moteur1(4, &can);
SDC21XX_Motor moteur1(&Robot_moteur, 1, 70, 1000);
SDC21XX_Motor moteur1(&Robot_moteur, 2, 50, 512);


int main(void)
{
    
    for(;;)
    {
        wait(3.0);
        moteur1.GoAngle(1000);
        moteur2.GoAngle(-1000);
        wait(3.0);
        moteur1.GoAngle(-1000);
        moteur2.GoAngle(1000);
    }
}


/**************************************************/




#ifndef SDC21XX_MOTOR_H
#define SDC21XX_MOTOR_H

#include "mbed.h"
#include "Roboteq.h"

namespace mbed {
    
    class SDC21XX_Motor {
        
        public :
        
        SDC21XX_Motor(uint8_t _node_id, CAN * _can, uint8_t _channel, uint32_t _reductor, uint32_t _enc_resolution);
        SDC21XX_Motor(Roboteq *_RB, uint8_t _channel, uint32_t _reductor, uint32_t _enc_resolution);
        void GoAngle(int16_t _angle);
        int16_t GetAngle();
        void SetChannel(uint8_t _channel);
        uint8_t GetChannel(void);
        void SetReductor(uint32_t _reductor);
        uint32_t GetReductor(void);
        void SetNodeID(uint8_t _node_id);
        uint8_t GetNodeID(void);
        void SetCan(CAN * _can);
        CAN* GetCan(void);
        void SetVelocity(uint16_t _vel);
        void SetAcceleration(long _accel);
        void SetDeceleration(long _decel);
        void Setparameters(uint16_t _vel, long _accel, long _decel);
        void SetRB (Roboteq* _RB);
        Roboteq* GetRB(void);

        
        private :
        
        protected :
        
        Roboteq RB;
        uint8_t channel;
        uint32_t reductor;
        uint32_t enc_resolution;
        
        
    };//end class




}//end namespace

#endif