#include "SDC21XX_Motor.h"


namespace mbed {
    
    SDC21XX_Motor::SDC21XX_Motor(uint8_t _node_id, CAN * _can, uint8_t _channel, uint32_t _reductor, uint32_t _enc_resolution): RB(_node_id, _can), channel(_channel), reductor(_reductor), enc_resolution(_enc_resolution)
    {
        
    }
    
    SDC21XX_Motor::SDC21XX_Motor(Roboteq *_RB, uint8_t _channel, uint32_t _reductor, uint32_t _enc_resolution): RB(_RB->GetNodeID(), _RB->GetCan()), channel(_channel), reductor(_reductor), enc_resolution(_enc_resolution)
    {
        
    }
    
    void SDC21XX_Motor::GoAngle(int16_t _angle)
    {
        RB.SetPosition(_angle*enc_resolution*reductor/360, channel);
    }
    
    int16_t SDC21XX_Motor::GetAngle()
    {
        return RB.ReadAbsoluteEncoderCount(channel)*360/enc_resolution/reductor;
    }
    
    void SDC21XX_Motor::SetChannel(uint8_t _channel)
    {
        channel = _channel;
    }
    
    uint8_t SDC21XX_Motor::GetChannel(void)
    {
        return channel;
    }
    
    void SDC21XX_Motor::SetReductor(uint32_t _reductor)
    {
        reductor = _reductor;
    }
    
    uint32_t SDC21XX_Motor::GetReductor(void)
    {
        return reductor;
    }
    
    void SDC21XX_Motor::SetNodeID(uint8_t _node_id)
    {
        RB.SetNodeID(_node_id);
    }
    
    uint8_t SDC21XX_Motor::GetNodeID(void)
    {
        return RB.GetNodeID();
    }
    
    void SDC21XX_Motor::SetCan(CAN * _can)
    {
        RB.SetCan(_can);
    }
    
    CAN* SDC21XX_Motor::GetCan(void)
    {
        return RB.GetCan();
    }
    
    void SDC21XX_Motor::SetVelocity(uint16_t _vel)
    {
        RB.SetVelocity(_vel, channel);
    }
    
    void SDC21XX_Motor::SetAcceleration(long _accel)
    {
        RB.SetAcceleration(_accel, channel);
    }
    
    void SDC21XX_Motor::SetDeceleration(long _decel)
    {
        RB.SetDeceleration(_decel, channel);
    }
    
    void SDC21XX_Motor::Setparameters(uint16_t _vel, long _accel, long _decel)
    {
        RB.SetParameters(_vel, _accel, _decel, channel);
    }

    void SDC21XX_Motor::SetRB(Roboteq* _RB)
    {
        RB = *_RB;
    }
    Roboteq* SDC21XX_Motor::GetRB(void)
    {
        return &RB;
    }


    
}//end namespace