#ifndef CANOPEN_NODE_H
#define CANOPEN_NODE_H

#include "mbed.h"


/**************************************************/
/* CANopen-Node class :
        - Contains :    node-id, identifier of the node to communicate with, range from 1 to 127
                        can, pointer to the CAN instance used to communicate with the node

        - Methods :     2 constructors, 1 of them setting the frequency of the CAN bus
                        Getters and setters for every variable
                        Send SDO up- and download, to send and receive basic messages over CANopen protocol
*/
/**************************************************/

/**************************************************/
/* Example program

#include "mbed.h"
#include "CANopen_node.h"

//Create a CANopen node object with node identifier 1, CAN frequency = 1Mbps
CAN can(p30, p29);
CANopen_Node CAN_node(1, &can, 1000000);


int main(void)
{
    
    for(;;)
    {
        wait(1);
        CAN_node.Send_Initiate_SDO_Download(0x2000, 0x05, 0x800004f3);
        
    }
    return 1;    
}


*/
/**************************************************/



namespace mbed {
    class CANopen_Node {
        
        public :
            
        CANopen_Node(uint8_t _id, CAN * _can);
        CANopen_Node(uint8_t _id, CAN * _can, int _baud);
        int Send_Initiate_SDO_Download(short index, short subindex, long data);
        int Send_Initiate_SDO_Upload(short index, short subindex);
        short GetNodeID(void);
        void SetNodeID(uint8_t _id);
        void SetCan(CAN * _can);
        CAN* GetCan(void);
        
        private :
        
        
        protected :
        
        short node_id;
        CAN * can;
        
        
        
    };//end class
    
    
    
}//end namespace

#endif