#include "CANopen_Node.h"


namespace mbed {
    
        CANopen_Node::CANopen_Node(uint8_t _id, CAN * _can): node_id(_id), can(_can)
        {
            
        }
        CANopen_Node::CANopen_Node(uint8_t _id, CAN * _can, int _baud): node_id(_id), can(_can)
        {
            can->frequency(_baud);
            
        }
        int CANopen_Node::Send_Initiate_SDO_Download(short index, short subindex, long data)
        {
            char _data[8];
            _data[0] = 0x22;
            _data[1] = index;
            _data[2] = index >> 8;
            _data[3] = subindex;
            _data[4] = data >> 0;
            _data[5] = data >> 8;
            _data[6] = data >> 16;
            _data[7] = data >> 24;
            return can->write(CANMessage(0x600 + node_id, _data, 8));
            
        }
        int32_t CANopen_Node::Send_Initiate_SDO_Upload(short index, short subindex)
        {
            char _data[8];
            _data[0] = 0x60;
            _data[1] = index;
            _data[2] = index >> 8;
            _data[3] = subindex;
            _data[4] = 0;
            _data[5] = 0;
            _data[6] = 0;
            _data[7] = 0;
            CANMessage _message(0x600 + node_id, _data, 8);
            can->write(_message);
            can->read(_message);
            return (_message.data[4] | _message.data[5] << 8 | _message.data[6] << 16 | _message.data[7] << 24);
            
        }
        short CANopen_Node::GetNodeID(void)
        {
            return node_id;
            
        }
        void CANopen_Node::SetNodeID(uint8_t _id)
        {
            node_id = _id;
            
        }
        
        void CANopen_Node::SetCan(CAN * _can)
        {
            can = _can;
        }
        
        CAN* CANopen_Node::GetCan(void)
        {
            return can;
        }



    
}//end namespace