/* @file MultiKey.cpp
|| @vesion 1.2 
|| @modified by Istvan Cserny 
|| @contact https://developer.mbed.org/users/icserny/
|| @version 1.1
|| @modified by Diego (http://hotboards.org)
|| @version 1.0
|| @author Mark Stanley
|| @contact mstanley@technologist.com
||
|| @description
|| | The latest version, 3.0, of the keypad library supports up to 10
|| | active keys all being pressed at the same time. This sketch is an
|| | example of how you can get multiple key presses from a keypad or
|| | keyboard.

*/
#include "mbed.h"
#include "Hotboards_keypad.h"
#include <string>

using std::string;

// Defines the keys array with it's respective number of rows & cols,
// and with the value of each key
char keys[ 4 ][ 4 ] =
{
    { '1' , '2' , '3' , 'A' },
    { '4' , '5' , '6' , 'B' },
    { '7' , '8' , '9' , 'C' },
    { '*' , '0' , '#' , 'D' }
};

// Defines the pins connected to the rows
DigitalInOut rowPins[ 4 ] = { PTB8 , PTB9 , PTB10 , PTB11 };
// Defines the pins connected to the cols
DigitalInOut colPins[ 4 ] = { PTE2 , PTE3 , PTE4 , PTE5 };

// Creates a new keyboard with the values entered before
Keypad kpd( makeKeymap( keys ) , rowPins , colPins , 4 , 4 );

// Configures the serial port
Serial pc( USBTX , USBRX );

int i;

int main()
{
    string msg;
    while(1)
    {
        // Fills kpd.key[ ] array with up-to 10 active keys.
        // Returns true if there are ANY active keys.        
        if( kpd.getKeys( ) )
        {
            // Scan the whole key list.
            for( i = 0 ; i < LIST_MAX ; i++ )
            {
                // Only find keys that have changed state.
                if( kpd.key[ i ].stateChanged )
                {
                    // Report active key state : IDLE, PRESSED, HOLD, or RELEASED
                    switch( kpd.key[ i ].kstate )
                    {
                        case PRESSED:
                            msg = " PRESSED. ";
                            break;
                        case HOLD:
                            msg = " HOLD. ";
                            break;
                        case RELEASED:
                            msg = " RELEASED. ";
                            break;
                        case IDLE:
                            msg = " IDLE. ";
                            break;
                        default:
                            break;
                    }
                    // Print the current state of the key pressed
                    pc.printf( "Key " );              
                    pc.printf( "%c" , kpd.key[ i ].kchar );
                    pc.printf( "%s" , msg.c_str() );
                    pc.printf( "\n\r" );
                }
            }
        }
    }
}
