#include "mbed.h"
#include "USBHID.h"

//We declare a USBHID device. By default input and output reports are 8 bytes long.
USBHID hid(8, 8);

HID_REPORT send_report;                                 //This report will contain data to be sent
HID_REPORT recv_report;                                 //This report will contain data received

DigitalOut LED_1(LED1);
PwmOut LED_2(LED2);
DigitalIn SW1(D3,PullUp);;
AnalogIn adc(A0);

int main(void)
{
    send_report.length = 8;
    LED_1 = 1;
    LED_2.period_ms(20);

    while (1) {
        uint16_t raw = adc.read_u16();                  //Read ADC (A0 chan)
        for (int i = 0; i < send_report.length; i++)    //Fill the report
            send_report.data[i] = 0x00;
        send_report.data[0] = SW1.read();
        send_report.data[3] = (raw>>8);
        send_report.data[4] = (raw & 0xff);
        hid.send(&send_report);                         //Send the report

        if(hid.readNB(&recv_report)) {                  //try to read a msg
            LED_1 = !recv_report.data[0];
            LED_2.write(1.0 - recv_report.data[1]*0.01f);
        }
    }
}
