/** 12_rtos_timer
 * LED blinking by four RTOS timer - a Handbook demo
 * Link: https://developer.mbed.org/users/mbed_official/code/rtos_timer/docs/9dd7d49be2c3/main_8cpp_source.html
 *
 * Hardware requirements:
 * - FRDM-KL25Z board
 * - 4 LEDs (with current limiting resistors) connected to the Arduino compatible D4,D5,D6,D7 pins
 */


#include "mbed.h"
#include "rtos.h"

DigitalOut LEDs[4] = {DigitalOut(D4), DigitalOut(D5), DigitalOut(D6), DigitalOut(D7)};
 
void blink(void const *n) {
    LEDs[(int)n] = !LEDs[(int)n];
}
 
int main(void) {            
    RtosTimer led_1_timer(blink, osTimerPeriodic, (void *)0);
    RtosTimer led_2_timer(blink, osTimerPeriodic, (void *)1);
    RtosTimer led_3_timer(blink, osTimerPeriodic, (void *)2);
    RtosTimer led_4_timer(blink, osTimerPeriodic, (void *)3);
    
    led_1_timer.start(2000);
    led_2_timer.start(1000);
    led_3_timer.start(500);
    led_4_timer.start(250);
    
    Thread::wait(osWaitForever);
}