/** 10_rtos_queue
 *
 * Simple example to use a Queue object to send integer data
 * from thread1 to thread2. Note that Queue's put() method is
 * intended to send a pointer, therefore typecasting
 * should be appliedin in order to avoid compiler error messages.
 */

#include "mbed.h"
#include "rtos.h"

AnalogIn potmeter(A0);
PwmOut myled(LED_BLUE);

typedef uint32_t message_t;
Queue<message_t, 16> queue;

void led_thread(void const *argument)
{
    myled.period_us(16384);                                       //Set period to 16.384 ms
    myled.pulsewidth_us(8192);                                    //Initialize to 50% duty cycle
    while (true) {
        osEvent evt = queue.get();                                //Wait for a message
        switch(evt.status) {
            case osOK:
                printf("osOK\n");                                 //no error, no message arrived
                break;
            case osEventMessage:
                printf("osEventMessage = %#05x\n",evt.value.v);  //message arrived
                //Note that evt.value is a union.
                //Read as value.v to get a data, or value.p to get a pointer...
                myled.pulsewidth_us((int)(evt.value.v>>2));      //roughly 0..16 ms
                break;
            case osEventTimeout:
                printf("osEventTimeout\n");                      //timeout occurred
                break;
            case osErrorParameter:
                printf("osErrorParameter\n");
                break;                                           //invalid parameter or is out of range.
            default:
                printf("Unknown error flag: %#08x\n",(uint32_t)evt.status);
                break;
        };
    }
}

int main (void)
{
    Thread thread2(led_thread);

    while (true) {
        Thread::wait(1000);
        uint16_t raw = potmeter.read_u16();                     // read raw 16-bit data
        queue.put((message_t*)raw);
    }
}
