/** 10_rtos_signals_to_main
 *
 * Synchronize two tasks by the help of an event signal.
 * Thread1 (the main() thread) changes the state of LED1 when an event flag arrives.
 * Thread2 sends event flags at reguar intervals.
 * The main problem is here: how to address thread1?
 * We use Thread::gettid() to obtain the task ID of the main task.
 * In order to send a signal, we have to use the osSignalSet()
 * function from the underlaying CMSIS RTOS layer.
 * Source: https://developer.mbed.org/questions/1256/How-to-reference-the-main-thread-when-us/
 */

#include "mbed.h"
#include "rtos.h"
 
DigitalOut led(LED1);
osThreadId mainThreadID;
 
void signal_thread(void const *argument) {
    while (true) {
        Thread::wait(1000);
        osSignalSet(mainThreadID, 0x1);
    }
}
 
int main (void) {
    mainThreadID = Thread::gettid();
    Thread thread(signal_thread);
    
    while (true) {
        // Signal flags that are reported as event are automatically cleared.
        osSignalWait(0x1, osWaitForever);
        led = !led;
    }
}
