/** 10_rtos_signals_ledblink
 *
 * Synchronize two tasks by the help of an event signal.
 * Thread2 changes the state of LED1 when an event flag arrives.
 * Thread1 (the main thread) sends event flags at reguar intervals.
 */

#include "mbed.h"
#include "rtos.h"

DigitalOut led(LED1);

void led_thread(void const *argument)
{
    while (true) {
        // Signal flags that are reported as event are automatically cleared.
        osEvent evt = Thread::signal_wait(0x1);   //Wait for a signal
        led = !led;
    }
}

int main (void)
{
    Thread thread2(led_thread);

    while (true) {
        Thread::wait(1000);
        thread2.signal_set(0x1);
    }
}
