/** 10_rtos_signals
 *
 * Synchronize two tasks by the help of event signals.
 * Thread2 changes the state of LED1 when any event flag arrives.
 * Thread1 (the main thread) sends event flags at reguar intervals.
 * You may experimenting by changeing this program:
 *  - Wait for a given flag: for example Thread::signal_wait(0x8);  
 *  - Wait for multiple events: for example Thread::signal_wait(0x5);
 *  - Wait for a nonexistent events: for example Thread::signal_wait(0x10000);
 *  - Wait for a limited time: for example Thread::signal_wait(0x3,500);
 *
 * Watch the output in a Terminal window!
 */

#include "mbed.h"
#include "rtos.h"

DigitalOut led(LED1);

void led_thread(void const *argument)
{
    while (true) {
        // Signal flags that are reported as event are automatically cleared.
        osEvent evt = Thread::signal_wait(0);                           //Wait for any signal
        switch(evt.status) {
            case osOK:
                printf("osOK\n");                                       //no error or event occurred
                break;
            case osEventSignal:
                printf("osEventSignal = %#05x\n",evt.value.signals);    //signal event occurred
                break;              
            case osEventTimeout:
                printf("osEventTimeout\n");                             //timeout occurred
                break;               
            case osErrorValue:
                printf("osErrorValue\n");
                break;                                                  //value of a parameter is out of range.               
            default:
                printf("Unknown error flag: %#08x\n",(uint32_t)evt.status);
                break;
        };
        led = !led;
    }
}

int main (void)
{
    int32_t signal_mask = 0x1;
    Thread thread2(led_thread);

    while (true) {
        Thread::wait(1000);
        thread2.signal_set(signal_mask);                                //send signals from 0x0001 to 0x8000
        signal_mask <<=1;                                               //switch to next signal
        if(signal_mask > 0x8000) signal_mask=0x1;
    }
}
