/** 10_rtos_dpp_easy
 * Dining Philosopher Problem - in the easy way
 * We have five philosopher sitting around a table
 * and they are either thinking or eating.
 * There is rice on the table, but there are only
 * five chopsticks - and one need two of them for eating.
 *
 * In this easy treatment ANY two of the five chpsticks 
 * can be used for eating - if we can acquire them. 
 * The five chopsticks are represneted by a 5-slots 
 * semaphore (a semaphore counting from 0 to 5).  
 * The philosophers are represented as threads.
 *
 * Hardware requirements:
 *  - FRDM-KL25Z board
 */

#include "mbed.h"
#include "rtos.h"

Semaphore s(5);                             //a pool of 5 chopsticks
Mutex stdio_mutex;                          //Mutex is required only for Cortex-M0 as stdio access is unprotected in C microlib 
Timer mytime;

void notify(const char* name) {
    stdio_mutex.lock();
    printf("%s acquired two chopsticks %8.1f\n\r", name,mytime.read());
    stdio_mutex.unlock();
}

void test_thread(void const* args) {
    while (true) {
        Thread::wait(1000+rand()%500);      //Thinking   
        s.wait();
        s.wait();        
        notify((const char*)args);
        Thread::wait(500+rand()%500);       //Eating
        s.release();
        s.release();        
    }
}

int main (void)
{
    mytime.start();
    Thread t2(test_thread, (void *)"Philosopher 2");
    Thread t3(test_thread, (void *)"Philosopher 3");
    Thread t4(test_thread, (void *)"Philosopher 4");
    Thread t5(test_thread, (void *)"Philosopher 5");    
    test_thread((void *)"Philosopher 1");
}
