/** 09_rtos_basic
 * RTOS LED blinking example running 3 threads
 * (main and two additional threads)
 *
 * Hardware requirement:
 *  - FRDM-KL25Z board
 */

#include "mbed.h"
#include "rtos.h"
 
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
 
void led2_thread(void const *args) {
    while (true) {
        led2 = !led2;
        Thread::wait(2000);
    }
}

void led3_thread(void const *args) {
    while (true) {
        led3 = !led3;
        Thread::wait(4000);
    }
}
 
int main() {
    Thread thread2(led2_thread);
    Thread thread3(led3_thread);
        
    while (true) {
        led1 = !led1;
        Thread::wait(1000);
    }
}
