
#include "mbed.h"
/** 08_led_switch
 * Sitch on/off LED1 by a pushbutton tied between D3 and GND
 * The program implements a very simple inite State Machine (FSM) model
 *
 * Hardware requirements:
 *  - FRDM-KL25Z board
 *  - A pusbutton between D3 (PTA12) and GND
 */
DigitalIn SW1(D3,PullUp);
DigitalOut LED_1(LED_RED);

typedef enum  {                         //Set of possible states
    STATE_WAIT_FOR_PRESS,
    STATE_WAIT_FOR_RELEASE
} state_t;


int main()
{
    //Define initial state
    state_t mystate = STATE_WAIT_FOR_PRESS;
    LED_1 = 1;                          //LED off at start
    while (true) {
        switch(mystate) {
            case STATE_WAIT_FOR_PRESS:
                if (SW1==0)  {          //if button pressed
                    LED_1 = !LED_1;     //toggle LED_1
                    mystate = STATE_WAIT_FOR_RELEASE;
                }
                break;
            case STATE_WAIT_FOR_RELEASE:
                if (SW1==1) {           //if button released
                    mystate = STATE_WAIT_FOR_PRESS;
                }
        }
        wait_ms(20);                    //debounce delay
    }
}