/** 08_wakeup
 *
 * The LED is "off" for 2 seconds (the target spends this interval in deepsleep() mode)
 * then the LED is "on" for the other second. Awakening is arranged by using the WakeUp
 * class library.
 *
 * Author: Erik Olieman
 * Link: https://developer.mbed.org/users/Sissors/code/WakeUp/
 * Minor modifications: I. Cserny
 *
 * A note about the implementation of the WakeUp library:
 * ------------------------------------------------------
 * The KL25z target board uses the same LPTMR for both WakeUp and for ticker generation.
 * The WakeUp code is nice, and it will backup the old values when being set, and restore
 * those after waking up, allowing you to continue using your ticker, and a ticker which
 * was already set will continue again. However you are not allowed to set a new ticker
 * after you already set WakeUp, since this will give clashes. Do you for whatever reason
 * need to do it (for example you set WakeUp, and then you wake using an InteruptIn),
 * you can disable the WakeUp timer and restore the ticker functionality by setting
 * WakeUp for 0 seconds.
 */

#include "mbed.h"
#include "WakeUp.h"

DigitalOut myled(LED1);         //LED_RED

int main() {
    //The low-power oscillator can be quite inaccurate on some targets
    //this function calibrates it against the main clock
    WakeUp::calibrate();

    while(1) {
        myled = 1;              //Switch LED off        
        WakeUp::set_ms(2000);   //Set wakeup time for 2 seconds
        deepsleep();            //Enter deepsleep mode
//-- zzZZ sleep here for 2 seconds -------------------        
        myled = 0;              //Switch LED on after wakeup 
        wait(1);                //Run state for 1 sec
    }
}