/** 08_timeout_helloworld 
 *
 * Flip LED2 state after 2 seconds while LED1 blinks continuously. 
 * Link: https://developer.mbed.org/handbook/Timeout
 *
 * Hardware requirements:
 *  - FRDM-KL25Z board 
 */

#include "mbed.h"
 
Timeout flipper;
DigitalOut led1(LED1);          // LED_RED
DigitalOut led2(LED2);          // LED_GREEN
 
void flip() {                   // callback function
    led2 = !led2;               // flip state of LED_GREEN
}
 
int main() {
    led2 = 1;
    flipper.attach(&flip, 2.0); // setup flipper to call flip after 2 seconds
 
    // spin in a main loop. flipper will interrupt it to call flip
    while(1) {
        led1 = !led1;           // blink LED_RED
        wait(0.2);              // by 2.5 Hz (0.2s ON, 0.2s OFF)
    }
}
