/** 08_reaction_time
 * Reaction time measurement
 * Result will be outputted to terminal
 * Based on program written by Albertas Galin
 * Link: https://developer.mbed.org/users/albertas/code/Reaction_timer/file/436ae35cdd94/main.cpp
 *
 * Hardware requirements:
 *  - FRDM-KL25Z board
 *  - Pusbutton (tied between D3 and GND) 
 */

#include "mbed.h"
DigitalOut myled(LED_GREEN);        //define LED
DigitalIn mybutton(D3,PullUp);      //define pushbutton input with pull-up
Timer t;                            //define timer
int x;                              //x for random number storage

int main()
{
    myled = 1;                      //LED is initially off 
    printf("\r\nReaction test!\r\n");
    printf("Push the button when the LED is on!\r\n");
    while(1) {
        while(!mybutton);           //wait for button release
        x=rand()%2000;              //generate random number 0-2000
        wait_ms(1000+x);            //wait random time between 1 and 3 seconds
        t.start();                  //start the timer
        myled=0;                    //LED on
        while(mybutton);            //wait for press
        t.stop();                   //stop the timer
        myled=1;                    //LED off
        wait_ms(20);                //debounce delay
        printf("The time taken was %f seconds\r\n", t.read());
        t.reset();                  //reset the timer
    }
}