/** 07_button_interrupt
 *
 * Switches a LED on/off by pushbutton interrupts.
 * Quite useless though instuctive example (due to button bounces...)
 *
 * Hardware requirements:
 *  - FRDM-KL25Z board
 *  - Pusbutton (tied between D3 and GND)
 */
 
#include "mbed.h"

InterruptIn button(D3);             // Pusbutton input
DigitalOut led(D13);                // LED output (the blue LED)

void button_pressed() {
    led = !led;                     // LED state is changed at every button press
}

int main() {
    button.mode(PullUp);            // Enable internal pullup
    button.fall(&button_pressed);   // Attach function to falling edge
    while (true) {
        wait(0.2f);                 // Nothing to do. Just wait
    }
}