/** 07_button_bounce
 *
 * Counts button bounces in a button press-release cycle
 * by using InterruptIn class library. Results are printed
 * out through UART0 (via OpenSDA).
 *
 * Hardware requirements:
 *  - FRDM-KL25Z board
 *  - Pusbutton (tied between D3 and GND)
 */

#include "mbed.h"
DigitalIn mybutton(D3,PullUp);      // Pushbutton input
InterruptIn button(D3);             // Pusbutton interrupt
Serial pc(USBTX,USBRX);             // UART0 via OpenSDA
volatile uint16_t counts;           // counter variable

void button_pressed() {
    counts++;                       // counts button presses
}

int main() {
    button.mode(PullUp);            // Enable internal pullup
    button.fall(&button_pressed);   // Attach function to falling edge
    while (true) {
        counts = 0;                 // Clear counter
        pc.printf("Press & release switch... \r\n");
        while (mybutton);           // Wait for button press
        wait_ms(20);                // Debounce delay
        while (!mybutton);          // Wait for button release
        wait_ms(20);                // Debounce delay
        pc.printf("Button pressed %d times\r\n",counts);
    }
}