/** 06_i2c_tcn75
 * Read temperature from a TCN75 (or LM75) I2C thermometer
 * I2C address: 1 0 0 1 A2 A2 A0
 *
 * Hardware requirements:
 *  - FRDM-KL25Z board
 *  - TCN75 (or LM75) thermometer
 *
 * Wiring scheme:
 *
 * TCN75         FRDM-25KLZ
 * -------------------------
 * 1. SDA        D14 (PTE0 alias I2C_SDA)
 * 2. SCL        D15 (PTE1 alias I2C_SCL)
 * 3. ALERT       -- (not used)
 * 4. GND        GND
 * 5. A2         GND
 * 6. A1         GND
 * 7. A0         GND
 * 8. VCC        3V3
 */

#include "mbed.h"
I2C i2c(I2C_SDA, I2C_SCL);        // Arduino compatible pins
const int addr = 0x90;            // TCN75 adress: 0x48<<1

int main()
{
    char cmd[2];                  // data buffer
    printf("\r\nTCN75 I2C thermometer\r\n");
    cmd[0] = 0x01;                // Pointer to CONFIG register
    cmd[1] = 0x00;                // Data for CONFOG register (Normal operation, comparator mode)
    i2c.write(addr, cmd, 2);      // Send Address/comman and two bytes
    while (1) {
        wait(1);
        cmd[0] = 0x00;            // Pointer to TEMP register
        i2c.write(addr, cmd, 1);  // Write adress/command byte, then register address
        i2c.read(addr, cmd, 2);   // Read 2 bytes from TEMP register
        float temp = cmd[0]<<8|cmd[1];
        printf("Temperatue = %.2f C\r\n", temp/256);
    }
}
