/** 06_frdm_uart2
 * Simple demo to demonstrate communication via UART2
 *
 * Hardware requirements:
 *  - FRDM-KL25Z board
 *  - USB-UART protocol converter (FTDI cable or similar)
 *
 *  Wiring: 
 *    FTDI RX to PTE22, FTDI TX to PTE23
 *    FTDI GND to GND, FTDI 5V to Vin
 */


#include "mbed.h"

DigitalOut myled(LED_GREEN);
Serial pc(PTE22, PTE23);

int main()
{
    int i = 0;
    pc.printf("Hello World!\r\n");

    while (true) {
        wait_ms(1000);          // wait a small period of time
        i++;                    // increment the variable
        myled = !myled;         // toggle a led
        int s = myled;
        pc.printf("%d. ledstate = %d \r\n", i,s);  // print variable i and LED state        
    }
}
