/** 05_analog_thermometer2
 * Measeures the temperature by using a Microchip MCP9700A
 * analog thermometer (parameteres: 10 mV/C, 500 mV offset, VCC= 2.3-5.5V)
 * Averaged result is printed to standard output.
 *
 * Hardware requirements:
 *  - FRDM-KL25Z board
 *  - MCP9700A analog thermometer connected to A0 (PTB0)
 */

#include "mbed.h"

AnalogIn ain(A0);                           // Analog input at PTB0
uint32_t mysum;                             // Used for summation

int main()
{
    printf("\r\n05_analog_thermometer2 - with averaging\r\n");
    while(1) {
        mysum = 0; 
        for(int i=0; i<3300; i++) {
            mysum += ain.read_u16();        // sum up raw 16-bit data
        }    
        float voltage = mysum>>16;          // voltage in millivolts
        float tempC = (voltage -500)/10;    // tempereature in Celsius
        printf("voltage: %5.0f mV temp: %5.1f C\r\n",voltage,tempC);
        wait(2);
    }
}
